/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.event;

import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.Optional;
import net.kayn.fallen_gems_affixes.adventure.affix.SpellCastAffix;
import net.kayn.fallen_gems_affixes.adventure.affix.SpellEffectAffix;
import net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus.SpellEffectBonus;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpellEventHandler {
    private static LivingEntity getSpellTarget(Optional<SpellCastAffix.TargetType> targetType, LivingEntity caster, LivingEntity contextTarget) {
        return targetType.filter(type -> type == SpellCastAffix.TargetType.SELF).map(type -> caster).orElse(contextTarget);
    }

    @SubscribeEvent
    public static void onSpellDamage(SpellDamageEvent event) {
        LivingEntity target = event.getEntity();
        if (target.m_9236_().f_46443_) {
            return;
        }
        SpellDamageSource source = event.getSpellDamageSource();
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity caster = (LivingEntity)entity;
        if (SpellCastAffix.isCurrentlyTriggering(caster)) {
            return;
        }
        for (ItemStack stack : caster.m_20158_()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Object patt2045$temp = inst.affix().get();
                if (patt2045$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)((Object)((Object)patt2045$temp));
                    if (affix.target == SpellEffectAffix.Target.SPELL_DAMAGE_TARGET) {
                        affix.applyEffect(target, (LootRarity)inst.rarity().get(), inst.level());
                    } else if (affix.target == SpellEffectAffix.Target.SPELL_DAMAGE_SELF) {
                        affix.applyEffect(caster, (LootRarity)inst.rarity().get(), inst.level());
                    }
                } else {
                    Object patt2507$temp = inst.affix().get();
                    if (patt2507$temp instanceof SpellCastAffix) {
                        SpellCastAffix affix = (SpellCastAffix)((Object)((Object)patt2507$temp));
                        if (affix.trigger == SpellCastAffix.TriggerType.SPELL_DAMAGE) {
                            LivingEntity actualTarget = SpellEventHandler.getSpellTarget(affix.target, caster, target);
                            affix.triggerSpell(caster, actualTarget, (LootRarity)inst.rarity().get(), (int)inst.level());
                        }
                    }
                }
            });
            SpellEventHandler.checkGemBonus(stack, (gem, bonus, rarity) -> {
                if (bonus.target == SpellEffectAffix.Target.SPELL_DAMAGE_TARGET) {
                    bonus.applyEffect(gem, target, rarity);
                } else if (bonus.target == SpellEffectAffix.Target.SPELL_DAMAGE_SELF) {
                    bonus.applyEffect(gem, caster, rarity);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onSpellHeal(SpellHealEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity caster = event.getEntity();
        if (SpellCastAffix.isCurrentlyTriggering(caster)) {
            return;
        }
        LivingEntity healTarget = event.getTargetEntity();
        for (ItemStack stack : caster.m_20158_()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Object patt3762$temp = inst.affix().get();
                if (patt3762$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)((Object)((Object)patt3762$temp));
                    if (affix.target == SpellEffectAffix.Target.SPELL_HEAL_TARGET) {
                        affix.applyEffect(healTarget, (LootRarity)inst.rarity().get(), inst.level());
                    } else if (affix.target == SpellEffectAffix.Target.SPELL_HEAL_SELF) {
                        affix.applyEffect(caster, (LootRarity)inst.rarity().get(), inst.level());
                    }
                } else {
                    Object patt4224$temp = inst.affix().get();
                    if (patt4224$temp instanceof SpellCastAffix) {
                        SpellCastAffix affix = (SpellCastAffix)((Object)((Object)patt4224$temp));
                        if (affix.trigger == SpellCastAffix.TriggerType.SPELL_HEAL) {
                            LivingEntity actualTarget = SpellEventHandler.getSpellTarget(affix.target, caster, healTarget);
                            affix.triggerSpell(caster, actualTarget, (LootRarity)inst.rarity().get(), (int)inst.level());
                        }
                    }
                }
            });
            SpellEventHandler.checkGemBonus(stack, (gem, bonus, rarity) -> {
                if (bonus.target == SpellEffectAffix.Target.SPELL_HEAL_TARGET) {
                    bonus.applyEffect(gem, healTarget, rarity);
                } else if (bonus.target == SpellEffectAffix.Target.SPELL_HEAL_SELF) {
                    bonus.applyEffect(gem, caster, rarity);
                }
            });
        }
    }

    public static void checkGemBonus(ItemStack itemStack, BonusProcessor processor) {
        if (itemStack.m_41619_()) {
            return;
        }
        LootCategory cat = LootCategory.forItem((ItemStack)itemStack);
        for (GemInstance g : SocketHelper.getGems((ItemStack)itemStack)) {
            DynamicHolder rarityHolder;
            if (!g.isValid() || !(rarityHolder = g.rarity()).isBound()) continue;
            LootRarity rarity = (LootRarity)rarityHolder.get();
            Gem gem = (Gem)g.gem().get();
            gem.getBonus(cat, rarity).filter(b -> b instanceof SpellEffectBonus).map(b -> (SpellEffectBonus)((Object)b)).ifPresent(bonus -> processor.accept(g.gemStack(), (SpellEffectBonus)((Object)bonus), rarity));
        }
    }

    @FunctionalInterface
    public static interface BonusProcessor {
        public void accept(ItemStack var1, SpellEffectBonus var2, LootRarity var3);
    }
}

