/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.event;

import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.kayn.fallen_gems_affixes.config.ModConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fallen_gems_affixes")
public class MobGearGemInjector {
    private static final String BOSS_KEY = "apoth.boss";

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (!((Boolean)ModConfig.ENABLE_SOCKET_GEM_MODIFIER.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        CompoundTag tag = le.getPersistentData();
        if (!tag.m_128471_(BOSS_KEY)) {
            return;
        }
        RandomSource random = level.m_213780_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            LootCategory category;
            int sockets;
            ItemStack stack = le.m_6844_(slot);
            if (stack.m_41619_() || (sockets = SocketHelper.getSockets((ItemStack)stack)) <= 0 || (category = LootCategory.forItem((ItemStack)stack)) == null || category.isNone()) continue;
            ArrayList<GemInstance> gems = new ArrayList<GemInstance>(Collections.nCopies(sockets, GemInstance.EMPTY));
            for (int i = 0; i < sockets; ++i) {
                GemInstance instance;
                ItemStack gemStack;
                GemInstance selected = GemInstance.EMPTY;
                if ((double)random.m_188501_() <= (Double)ModConfig.SOCKET_GEM_CHANCE.get() && !(gemStack = GemRegistry.createRandomGemStack((RandomSource)random, (ServerLevel)((ServerLevel)level), (float)1.0f, (Predicate[])new Predicate[]{g -> g.getBonuses().stream().anyMatch(bonus -> bonus.getGemClass() != null && bonus.getGemClass().types().contains(category))})).m_41619_() && (instance = GemInstance.socketed((ItemStack)stack, (ItemStack)gemStack)).isValid()) {
                    selected = instance;
                }
                gems.set(i, selected);
            }
            SocketHelper.setGems((ItemStack)stack, (SocketedGems)new SocketedGems(gems));
        }
    }
}

