/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.compat;

import net.kayn.fallen_gems_affixes.config.ModConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class CrescentiaSpellPowerPatch {
    private static final boolean HAS_CELESTISYNTH = ModList.get().isLoaded("celestisynth");
    private static final boolean HAS_IRONS = ModList.get().isLoaded("irons_spellbooks");
    private static final ResourceLocation CRESCENTIA_ID = new ResourceLocation("celestisynth", "crescentia");
    private static final ResourceLocation ENDER_SPELL_POWER_ID = new ResourceLocation("irons_spellbooks", "ender_spell_power");
    private static final Lazy<Attribute> ENDER_SPELL_POWER = Lazy.of(() -> HAS_IRONS ? (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ENDER_SPELL_POWER_ID) : null);

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!((Boolean)ModConfig.ENABLE_SPELL_POWER_PATCH.get()).booleanValue()) {
            return;
        }
        if (!HAS_CELESTISYNTH || !HAS_IRONS) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack held = player.m_21205_();
        if (!held.m_150930_((Item)ForgeRegistries.ITEMS.getValue(CRESCENTIA_ID))) {
            return;
        }
        Attribute attr = (Attribute)ENDER_SPELL_POWER.get();
        if (attr == null) {
            return;
        }
        AttributeInstance instance = player.m_21051_(attr);
        if (instance == null) {
            return;
        }
        double value = instance.m_22135_();
        if (value <= 0.0) {
            return;
        }
        event.setAmount(event.getAmount() + event.getAmount() * (float)value);
    }
}

