/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.PotionAffix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiEffectBonus
extends GemBonus {
    public static Codec<MultiEffectBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(MultiEffectBonus.gemClass(), (App)EffectInst.CODEC.listOf().fieldOf("effects").forGetter(a -> a.effects), (App)PotionAffix.Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply), (App)Codec.STRING.fieldOf("desc").forGetter(a -> a.desc)).apply((Applicative)inst, MultiEffectBonus::new));
    protected final List<EffectInst> effects;
    protected final PotionAffix.Target target;
    protected final boolean stackOnReapply;
    protected final String desc;

    public MultiEffectBonus(GemClass gemClass, List<EffectInst> effects, PotionAffix.Target target, boolean stackOnReapply, String desc) {
        super(new ResourceLocation("fallen_gems_affixes", "multi_effect"), gemClass);
        this.effects = effects;
        this.target = target;
        this.stackOnReapply = stackOnReapply;
        this.desc = desc;
    }

    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        Object[] values = new Object[this.effects.size()];
        int i = 0;
        for (EffectInst effectInst : this.effects) {
            MobEffectInstance inst = effectInst.values.get(rarity).build(effectInst.effect);
            MutableComponent effectComp = MultiEffectBonus.toComponent(inst);
            int cooldown = effectInst.values.get((Object)rarity).cooldown;
            if (cooldown != 0) {
                MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)}).m_130940_(ChatFormatting.YELLOW);
                effectComp = effectComp.m_130946_(" ").m_7220_((Component)cd);
            }
            values[i++] = effectComp;
        }
        MutableComponent comp = this.target.toComponent(new Object[]{Component.m_237110_((String)this.desc, (Object[])values)}).m_130940_(ChatFormatting.YELLOW);
        if (this.stackOnReapply) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public MultiEffectBonus validate() {
        Preconditions.checkNotNull(this.effects, (Object)"Invalid MultiEffectBonus with null effects");
        Preconditions.checkNotNull((Object)this.target, (Object)"Invalid MultiEffectBonus with null target");
        ArrayList rarityChecks = new ArrayList();
        for (EffectInst inst : this.effects) {
            HashSet set = new HashSet();
            RarityRegistry.INSTANCE.getValues().stream().filter(inst.values::containsKey).forEach(set::add);
            rarityChecks.add(set);
        }
        Preconditions.checkArgument((boolean)rarityChecks.stream().mapToInt(Set::size).allMatch(size -> size == ((Set)rarityChecks.get(0)).size()));
        return this;
    }

    public boolean supports(LootRarity rarity) {
        return this.effects.get((int)0).values.containsKey(rarity);
    }

    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public void doPostHurt(ItemStack gem, LootRarity rarity, LivingEntity user, Entity attacker) {
        if (this.target == PotionAffix.Target.HURT_SELF) {
            this.applyEffects(gem, user, rarity);
        } else if (this.target == PotionAffix.Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffects(gem, tLiving, rarity);
        }
    }

    public void doPostAttack(ItemStack gem, LootRarity rarity, LivingEntity user, Entity target) {
        if (this.target == PotionAffix.Target.ATTACK_SELF) {
            this.applyEffects(gem, user, rarity);
        } else if (this.target == PotionAffix.Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffects(gem, tLiving, rarity);
        }
    }

    public void onBlockBreak(ItemStack gem, LootRarity rarity, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.target == PotionAffix.Target.BREAK_SELF) {
            this.applyEffects(gem, (LivingEntity)player, rarity);
        }
    }

    public void onArrowImpact(ItemStack gem, LootRarity rarity, AbstractArrow arrow, HitResult res) {
        Entity entity;
        if (this.target == PotionAffix.Target.ARROW_SELF && (entity = arrow.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.applyEffects(gem, owner, rarity);
        } else if (this.target == PotionAffix.Target.ARROW_TARGET && res.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffects(gem, target, rarity);
        }
    }

    public float onShieldBlock(ItemStack gem, LootRarity rarity, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        if (this.target == PotionAffix.Target.BLOCK_SELF) {
            this.applyEffects(gem, entity, rarity);
        } else if (this.target == PotionAffix.Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffects(gem, target, rarity);
        }
        return amount;
    }

    private void applyEffects(ItemStack gemStack, LivingEntity target, LootRarity rarity) {
        for (EffectInst effectInst : this.effects) {
            this.applySingleEffect(gemStack, target, rarity, effectInst);
        }
    }

    private void applySingleEffect(ItemStack gemStack, LivingEntity target, LootRarity rarity, EffectInst effectInst) {
        EffectData data = effectInst.values.get(rarity);
        if (data == null) {
            return;
        }
        int cooldown = data.cooldown;
        ResourceLocation cooldownId = new ResourceLocation(this.getId().m_135827_(), this.getId().m_135815_() + "_" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effectInst.effect).m_135815_());
        if (cooldown > 0 && Affix.isOnCooldown((ResourceLocation)cooldownId, (int)cooldown, (LivingEntity)target)) {
            return;
        }
        MobEffectInstance existing = target.m_21124_(effectInst.effect);
        MobEffectInstance newInst = this.stackOnReapply && existing != null ? new MobEffectInstance(effectInst.effect, Math.max(existing.m_19557_(), data.duration), existing.m_19564_() + 1 + data.amplifier) : data.build(effectInst.effect);
        target.m_7292_(newInst);
        if (cooldown > 0) {
            Affix.startCooldown((ResourceLocation)cooldownId, (LivingEntity)target);
        }
    }

    public static MutableComponent toComponent(MobEffectInstance inst) {
        MutableComponent comp = Component.m_237115_((String)inst.m_19576_());
        MobEffect effect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            comp = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{comp, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            comp = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{comp, MobEffectUtil.m_267641_((MobEffectInstance)inst, (float)1.0f)});
        }
        return comp.m_130940_(effect.m_19483_().m_19497_());
    }

    protected record EffectInst(MobEffect effect, Map<LootRarity, EffectData> values) {
        public static Codec<EffectInst> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(EffectInst::effect), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(EffectInst::values)).apply((Applicative)inst, EffectInst::new));
    }

    public record EffectData(int duration, int amplifier, int cooldown) {
        public static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(EffectData::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(MobEffect effect) {
            return new MobEffectInstance(effect, this.duration, this.amplifier);
        }
    }
}

