/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BossSlayerBonus
extends GemBonus {
    public static final Codec<BossSlayerBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(BossSlayerBonus.gemClass(), (App)ResourceLocation.f_135803_.fieldOf("entity_tag").forGetter(b -> b.entityTag.f_203868_()), (App)VALUES_CODEC.fieldOf("values").forGetter(b -> b.values)).apply((Applicative)inst, (gemClass, tagId, values) -> new BossSlayerBonus((GemClass)gemClass, (TagKey<EntityType<?>>)TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)tagId), (Map<LootRarity, StepFunction>)values)));
    public final TagKey<EntityType<?>> entityTag;
    public final Map<LootRarity, StepFunction> values;

    public BossSlayerBonus(GemClass gemClass, TagKey<EntityType<?>> tag, Map<LootRarity, StepFunction> values) {
        super(new ResourceLocation("fallen_gems_affixes", "boss_slayer"), gemClass);
        this.entityTag = tag;
        this.values = values;
    }

    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        double percent = this.values.get(rarity).get(0.0f) * 100.0f;
        return Component.m_237110_((String)"bonus.fallen_gems_affixes.boss_slayer.desc", (Object[])new Object[]{String.format("%.0f", percent)}).m_130940_(ChatFormatting.YELLOW);
    }

    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    public BossSlayerBonus validate() {
        Preconditions.checkNotNull(this.entityTag, (Object)"BossSlayerBonus missing entity tag");
        Preconditions.checkNotNull(this.values, (Object)"BossSlayerBonus missing values");
        return this;
    }

    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

