/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.List;
import net.kayn.fallen_gems_affixes.FallenGemsAffixes;
import net.kayn.fallen_gems_affixes.adventure.socket.gem.GemBonusExtension;

public class ExtraGemBonusRegistry
extends DynamicRegistry<ExtraGemBonus> {
    public static final ExtraGemBonusRegistry INSTANCE = new ExtraGemBonusRegistry();
    protected Multimap<DynamicHolder<Gem>, ExtraGemBonus> extraBonuses = HashMultimap.create();

    public ExtraGemBonusRegistry() {
        super(FallenGemsAffixes.LOGGER, "extra_gem_bonuses", true, false);
    }

    protected void beginReload() {
        super.beginReload();
        this.extraBonuses = HashMultimap.create();
        this.clearExtraGemBonuses();
    }

    protected void onReload() {
        super.onReload();
        for (ExtraGemBonus extraBonus : this.getValues()) {
            this.extraBonuses.put(extraBonus.gem, (Object)extraBonus);
        }
        this.applyExtraGemBonuses();
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(FallenGemsAffixes.id("extra_gem_bonus"), ExtraGemBonus.CODEC);
    }

    private void applyExtraGemBonuses() {
        for (Gem gem : GemRegistry.INSTANCE.getValues()) {
            DynamicHolder holder = GemRegistry.INSTANCE.holder((CodecProvider)gem);
            for (ExtraGemBonus extraBonus : this.extraBonuses.get((Object)holder)) {
                for (GemBonus bonus : extraBonus.bonuses()) {
                    try {
                        ((GemBonusExtension)gem).fallen_gems_affixes$appendExtraBonus(bonus);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void clearExtraGemBonuses() {
        for (Gem gem : GemRegistry.INSTANCE.getValues()) {
            if (!(gem instanceof GemBonusExtension)) continue;
            GemBonusExtension extension = (GemBonusExtension)gem;
            extension.fallen_gems_affixes$clearExtraBonuses();
        }
    }

    public record ExtraGemBonus(DynamicHolder<Gem> gem, List<GemBonus> bonuses) implements CodecProvider<ExtraGemBonus>
    {
        public static final Codec<ExtraGemBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemRegistry.INSTANCE.holderCodec().fieldOf("gem").forGetter(ExtraGemBonus::gem), (App)GemBonus.CODEC.listOf().fieldOf("bonuses").forGetter(ExtraGemBonus::bonuses)).apply((Applicative)inst, ExtraGemBonus::new));

        public Codec<? extends ExtraGemBonus> getCodec() {
            return CODEC;
        }
    }
}

