/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kayn.fallen_gems_affixes.util.SpellCastUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.IForgeRegistry;

public class SpellCastAffix
extends Affix {
    private static final ThreadLocal<Set<UUID>> TRIGGERING_CASTERS = ThreadLocal.withInitial(HashSet::new);
    private static final Map<String, Map<UUID, Long>> COOLDOWNS = new HashMap<String, Map<UUID, Long>>();
    public static final Codec<SpellCastAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)((IForgeRegistry)SpellRegistry.REGISTRY.get()).getCodec().fieldOf("spell").forGetter(affix -> affix.spell), (App)TriggerType.CODEC.fieldOf("trigger").forGetter(affix -> affix.trigger), (App)LootRarity.mapCodec(TriggerData.CODEC).fieldOf("values").forGetter(affix -> affix.values), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(affix -> affix.cooldown), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(affix -> affix.types), (App)TargetType.CODEC.optionalFieldOf("target").forGetter(affix -> affix.target)).apply((Applicative)inst, SpellCastAffix::new));
    protected final AbstractSpell spell;
    public final TriggerType trigger;
    protected final Map<LootRarity, TriggerData> values;
    protected final int cooldown;
    protected final Set<LootCategory> types;
    public final Optional<TargetType> target;

    public static boolean isCurrentlyTriggering(LivingEntity caster) {
        return TRIGGERING_CASTERS.get().contains(caster.m_20148_());
    }

    private static void setTriggering(LivingEntity caster, boolean value) {
        if (value) {
            TRIGGERING_CASTERS.get().add(caster.m_20148_());
        } else {
            TRIGGERING_CASTERS.get().remove(caster.m_20148_());
        }
    }

    public static boolean isOnCooldown(String id, int ignoredCooldown, LivingEntity caster) {
        Map cdMap = COOLDOWNS.getOrDefault(id, new HashMap());
        long now = caster.m_9236_().m_46467_();
        return cdMap.getOrDefault(caster.m_20148_(), 0L) > now;
    }

    public static void startCooldown(String id, LivingEntity caster, int cooldown) {
        COOLDOWNS.computeIfAbsent(id, k -> new HashMap()).put(caster.m_20148_(), caster.m_9236_().m_46467_() + (long)cooldown);
    }

    public SpellCastAffix(AbstractSpell spell, TriggerType trigger, Map<LootRarity, TriggerData> values, int cooldown, Set<LootCategory> types, Optional<TargetType> target) {
        super(AffixType.ABILITY);
        this.spell = spell;
        this.trigger = trigger;
        this.values = values;
        this.cooldown = cooldown;
        this.types = types;
        this.target = target;
    }

    private int getCooldown(LootRarity rarity) {
        TriggerData data = this.values.get(rarity);
        if (data != null && data.cooldown() >= 0) {
            return data.cooldown();
        }
        return this.cooldown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSpell(LivingEntity caster, LivingEntity target, LootRarity rarity, int spellLevelOverride) {
        if (SpellCastAffix.isCurrentlyTriggering(caster)) {
            return;
        }
        TriggerData data = this.values.get(rarity);
        if (data == null || caster.m_9236_().m_5776_()) {
            return;
        }
        int spellLevel = spellLevelOverride > 0 ? spellLevelOverride : data.level().getRandomLevel(caster.m_217043_());
        String spellId = this.spell.getSpellId();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        boolean hasActiveRecast = magicData.getPlayerRecasts().hasRecastForSpell(spellId);
        int cooldownTicks = Math.max(2, this.getCooldown(rarity));
        if (!hasActiveRecast && SpellCastAffix.isOnCooldown(this.getId().toString(), cooldownTicks, caster)) {
            return;
        }
        SpellCastAffix.setTriggering(caster, true);
        try {
            SpellCastUtil.castSpell(caster, this.spell, spellLevel, target);
            if (!hasActiveRecast) {
                SpellCastAffix.startCooldown(this.getId().toString(), caster, cooldownTicks);
            }
        }
        finally {
            Objects.requireNonNull(caster.m_9236_().m_7654_()).execute(() -> SpellCastAffix.setTriggering(caster, false));
        }
    }

    private LivingEntity determineTarget(LivingEntity caster, LivingEntity defaultTarget) {
        return this.target.map(targetType -> targetType == TargetType.SELF ? caster : defaultTarget).orElse(defaultTarget);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float affixLevel) {
        TriggerData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int spellLevel = data.level().min() + Math.round(affixLevel * (float)(data.level().max() - data.level().min()));
        MutableComponent coloredSpellName = this.spell.getDisplayName(null).m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + spellLevel))).m_130948_(this.spell.getSchoolType().getDisplayName().m_7383_());
        boolean isSelfCast = this.target.map(t -> t == TargetType.SELF).orElse(false);
        MutableComponent comp = this.trigger.toComponent((Component)coloredSpellName, isSelfCast);
        int cooldownTicks = this.getCooldown(rarity);
        if (cooldownTicks != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldownTicks)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        return comp;
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float affixLevel) {
        TriggerData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int spellLevel = data.level().min() + Math.round(affixLevel * (float)(data.level().max() - data.level().min()));
        MutableComponent coloredSpellName = this.spell.getDisplayName(null).m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + spellLevel))).m_130948_(this.spell.getSchoolType().getDisplayName().m_7383_());
        boolean isSelfCast = this.target.map(t -> t == TargetType.SELF).orElse(false);
        MutableComponent comp = this.trigger.toComponent((Component)coloredSpellName, isSelfCast);
        int cooldownTicks = this.getCooldown(rarity);
        if (cooldownTicks != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldownTicks)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        return comp;
    }

    public void doPostAttack(ItemStack stack, LootRarity rarity, float affixLevel, LivingEntity user, @Nullable Entity target) {
        if (this.trigger == TriggerType.MELEE_HIT && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            LivingEntity actualTarget = this.determineTarget(user, livingTarget);
            this.triggerSpell(user, actualTarget, rarity, 0);
        }
    }

    public void doPostHurt(ItemStack stack, LootRarity rarity, float affixLevel, LivingEntity user, @Nullable Entity attacker) {
        if (this.trigger == TriggerType.HURT && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            LivingEntity defaultTarget = this.target.map(t -> t == TargetType.TARGET ? livingAttacker : user).orElse(user);
            LivingEntity actualTarget = this.determineTarget(user, defaultTarget);
            this.triggerSpell(user, actualTarget, rarity, 0);
        }
    }

    public void onArrowImpact(AbstractArrow arrow, LootRarity rarity, float affixLevel, HitResult res, HitResult.Type type) {
        EntityHitResult entityHit;
        Entity entity;
        if (this.trigger == TriggerType.PROJECTILE_HIT && type == HitResult.Type.ENTITY && res instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            entity = arrow.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                LivingEntity actualTarget = this.determineTarget(owner, hitEntity);
                this.triggerSpell(owner, actualTarget, rarity, 0);
            }
        }
    }

    public static enum TriggerType {
        SPELL_DAMAGE("spell_damage"),
        SPELL_HEAL("spell_heal"),
        MELEE_HIT("melee_hit"),
        PROJECTILE_HIT("projectile_hit"),
        HURT("hurt");

        public static final Codec<TriggerType> CODEC;
        private final String id;

        private TriggerType(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Component spellName, boolean isSelfCast) {
            String key = "affix.fallen_gems_affixes.trigger." + this.id + (isSelfCast ? ".self" : "");
            return Component.m_237110_((String)key, (Object[])new Object[]{spellName});
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(TriggerType.class);
        }
    }

    public record TriggerData(LevelRange level, int cooldown) {
        public static final Codec<TriggerData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LevelRange.CODEC.fieldOf("level").forGetter(TriggerData::level), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)-1).forGetter(TriggerData::cooldown)).apply((Applicative)inst, TriggerData::new));
    }

    public record LevelRange(int min, int max) {
        public static final Codec<LevelRange> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("min").forGetter(LevelRange::min), (App)Codec.INT.fieldOf("max").forGetter(LevelRange::max)).apply((Applicative)inst, LevelRange::new));

        public int getRandomLevel(RandomSource random) {
            return this.min + random.m_188503_(this.max - this.min + 1);
        }
    }

    public static enum TargetType {
        SELF,
        TARGET;

        public static final Codec<TargetType> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(TargetType.class);
        }
    }
}

