/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kayn.fallen_gems_affixes.FallenGemsAffixes;
import net.kayn.fallen_gems_affixes.config.ModConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AdaptiveSpellPowerAffix
extends AttributeAffix {
    public static final Codec<AdaptiveSpellPowerAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)ResourceLocation.f_135803_.fieldOf("school").forGetter(a -> a.schoolId)).apply((Applicative)inst, AdaptiveSpellPowerAffix::new));
    protected final ResourceLocation schoolId;
    protected final SchoolType school;
    public static final Map<Item, Set<SchoolType>> recordedIronsItems = new HashMap<Item, Set<SchoolType>>();

    @SubscribeEvent
    public static void loadingIronsItemsFromConfig(ModConfigEvent event) {
        List raw = (List)ModConfig.IRONS_ITEMS_MAP.get();
        raw.forEach(entry -> {
            String[] split = entry.trim().split("\\|", 0);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
            if (item == null) {
                return;
            }
            HashSet<SchoolType> schoolTypes = new HashSet<SchoolType>();
            for (int i = 1; i < split.length; ++i) {
                SchoolType school = SchoolRegistry.getSchool((ResourceLocation)new ResourceLocation(split[i]));
                if (school == null) continue;
                schoolTypes.add(school);
            }
            if (!schoolTypes.isEmpty()) {
                recordedIronsItems.put(item, schoolTypes);
            }
        });
    }

    public AdaptiveSpellPowerAffix(Attribute attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values, Set<LootCategory> types, ResourceLocation schoolId) {
        super(attr, op, values, types);
        this.schoolId = schoolId;
        this.school = SchoolRegistry.getSchool((ResourceLocation)schoolId);
        if (this.school == null) {
            FallenGemsAffixes.LOGGER.error("A Null SchoolType is created, {}", (Object)this.schoolId);
        }
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone()) {
            return false;
        }
        if (!this.modifiers.containsKey(rarity)) {
            return false;
        }
        if (this.types.isEmpty()) {
            return true;
        }
        Item item = stack.m_41720_();
        Set<SchoolType> schoolTypes = recordedIronsItems.get(item);
        if (schoolTypes != null && schoolTypes.contains(this.school)) {
            return true;
        }
        if (!this.types.contains(cat)) {
            return false;
        }
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)stack);
        Set foundAttributes = new HashSet();
        if (item instanceof ICurioItem) {
            ICurioItem curio = (ICurioItem)item;
            Set slots = CuriosApi.getCuriosHelper().getCurioTags(item);
            for (String slotId : slots) {
                SlotContext context = new SlotContext(slotId, null, -1, false, true);
                foundAttributes.addAll(curio.getAttributeModifiers(context, UUID.randomUUID(), stack).keySet());
            }
        } else {
            foundAttributes = item.getAttributeModifiers(slot, stack).keySet();
        }
        for (Attribute attribute : foundAttributes) {
            String path;
            ResourceLocation attrId = BuiltInRegistries.f_256951_.m_7981_((Object)attribute);
            if (attrId == null || !(path = attrId.m_135815_()).endsWith("spell_power") || path.length() == 11) continue;
            String schoolName = path.replace("_spell_power", "");
            ResourceLocation schoolResource = new ResourceLocation(attrId.m_135827_(), schoolName);
            SchoolType matchedSchool = SchoolRegistry.getSchool((ResourceLocation)schoolResource);
            if (matchedSchool == null || this.school != matchedSchool) continue;
            return true;
        }
        return (Boolean)ModConfig.STRICT_SCHOOL_MATCH.get() == false;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

