/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String SOCKET_HELPER_MIXIN = "net.kayn.fallen_gems_affixes.mixin.SocketHelperMixin";
    private static final String GUN_MIXIN = "net.kayn.fallen_gems_affixes.mixin.GunModifierHelperMixin";
    private static final String PE_CLIENT_LIVING_ENTITY_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.client.LivingEntityMixin";
    private static final String PE_CLIENT_ABSTRACT_CONTAINER_MENU_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.client.AbstractContainerMenuMixin";
    private static final String PE_CLIENT_PLAYER_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.client.PlayerMixin";
    private static final String PE_CLIENT_SLOT_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.client.SlotMixin";
    private static final String PE_CLIENT_MINECRAFT_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.client.MinecraftMixin";
    private static final String PE_INVENTORY_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.InventoryMixin";
    private static final String PE_LIVING_ENTITY_MIXIN = "net.kayn.fallen_gems_affixes.mixin.permanent_effect.LivingEntityMixin";
    private static boolean enableSocketMixin = true;
    private static boolean enablePermanentEffectDefaultMixin = true;

    public void onLoad(String mixinPackage) {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("fallen_gems_affixes-common.toml");
        if (Files.notExists(configPath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("enableSocketHelperMixin") && (parts = line.split("=", 2)).length == 2) {
                    enableSocketMixin = Boolean.parseBoolean(parts[1].trim());
                }
                if (!line.startsWith("permanentEffectUseTickEvent") || (parts = line.split("=", 2)).length != 2) continue;
                enablePermanentEffectDefaultMixin = !Boolean.parseBoolean(parts[1].trim());
                break;
            }
        }
        catch (IOException ignored) {
            enableSocketMixin = true;
            enablePermanentEffectDefaultMixin = true;
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return switch (mixinClassName) {
            case SOCKET_HELPER_MIXIN -> enableSocketMixin;
            case PE_CLIENT_LIVING_ENTITY_MIXIN -> enablePermanentEffectDefaultMixin;
            case PE_CLIENT_ABSTRACT_CONTAINER_MENU_MIXIN -> enablePermanentEffectDefaultMixin;
            case PE_CLIENT_PLAYER_MIXIN -> enablePermanentEffectDefaultMixin;
            case PE_CLIENT_SLOT_MIXIN -> enablePermanentEffectDefaultMixin;
            case PE_CLIENT_MINECRAFT_MIXIN -> enablePermanentEffectDefaultMixin;
            case PE_INVENTORY_MIXIN -> enablePermanentEffectDefaultMixin;
            case PE_LIVING_ENTITY_MIXIN -> enablePermanentEffectDefaultMixin;
            case GUN_MIXIN -> MixinConfigPlugin.isModLoaded();
            default -> true;
        };
    }

    private static boolean isModLoaded() {
        return LoadingModList.get().getMods().stream().anyMatch(modInfo -> "scguns".equals(modInfo.getModId()));
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

