#version 120

#define MAX_COLOR_RANGE 48.0
/*
!! DO NOT REMOVE !!
BSL Shaders is derived from Chocapic13 v5 test 2

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//ADJUSTABLE VARIABLES//
	
	#define WorldDimension 0								//The world dimension you're in. -1 : Nether | 0 : Overworld | 1 : End [0 -1 1]
	#define Blur_Distance 8									//Set distant blur starting point. Insert Minecraft's render distance here for best result. [2 4 6 8 10 12 14 16]
	
	#define Vignette										//Darkens the corner.
		#define Vignette_Strength 0.8						//Set how dark the vignette will be. [0.2 0.4 0.6 0.8 1.0]
		#define Vignette_Start 0.0							//Distance from the center of the screen where the vignette effect start. [0.0 0.2 0.4 0.6]
		#define Vignette_End 1.5							//Distance from the center of the screen where the vignette effect end. [1.5 1.3 1.1 0.9]
	
	#define LensFlare										//Creates lens flare.
		#define LensFlare_Sun								//Enables lens flare during day time.
		#define LensFlare_Moon								//Enables lens flare during night time.
		#define Lens_Strength 1.0							//Visibility of lens flare. [0.5 1.0 1.5 2.0]

	#define Bloom											//Makes glow effect on bright stuffs.
		#define Bloom_Strength 1.00							//Set bloom strength. [0.25 0.5 0.75 1.00 1.25 1.50 1.75 2.0 2.25 2.50]

	//#define DOF											//Blurs non-focused objects.
		#define DOF_BokehCircle								//Blur will have circle shape.
		//#define DOF_BokehHexagon							//Blur will have hexagon shape.
		//#define DOF_BokehCircleLow						//Blur will have circle shape. Less detailed than circle bokeh. Recommended for lower blur size.
		
		//#define DOF_DistantBlur							//Blurs everything far away.
		//#define DOF_HandBlur								//Enable to blur hand.
		#define DOF_DualBlur								//Enables normal DOF and Distant blur.
		//#define ChromaticAbberation						//Seperates red and blue channel slightly from the center at the blurred area. Needs DOF to work.
		#define ChromaticAbberation_Strength 1.0			//Set channel seperation size. [0.5 1.0 1.5 2.0]
		
		const float focal = 0.025;
		float aperture = 0.01;
		const float sizemult = 100.0;
		
		#define DOF_BlurSize 4								//Set blur strength. [1 2 4 8 16 32]
		

	//#define MotionBlur									//Sweeps screen when looking/moving too fast.
		#define MotionBlur_Pass 8							//Set how smooth the blur is. [4 8 16]
		#define MotionBlur_Strength 0.12					//Set blur strength. [0.06 0.12 0.18 0.24]
	
	//#define Temperature									//Gives temperature based tinting.
		#define Temperature_Cold							//Set temperature to cold.
		//#define Temperature_Hot							//Set temperature to hot.
		#define Temperature_Strength 0.1					//Set temperature tinting strength. [0.1 0.2 0.3 0.4 0.5]
		
	//#define Old_School									//Limits color to create old school effect.
		#define Old_School_Limit 8							//Set number of tones available for a color. [2 4 8 16 32]
	
	//#define WorldTimeAnimation
	
	#define Color_Brightness 1.15							//Set color brightness value. [0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30]
	#define Color_Saturation 0.95							//Set color saturation value. [0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30]
	
//TONEMAP		
float A = 1.0;		//brightness multiplier
float B = 0.37;		//black level (lower means darker and more constrasted, higher make the image whiter and less constrasted)
float C = 0.1;		//constrast level 
	
//ADJUSTABLE VARIABLES//



varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float eyeAdapt;
uniform float centerDepthSmooth;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D noisetex;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D composite;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;

vec3 sunPos = sunPosition;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;
float dimread = WorldDimension;

//World Time Animation
#ifdef WorldTimeAnimation
float frametime = worldTime/20.0;
#else
float frametime = frameTimeCounter;
#endif

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}
											
	//hexagon pattern
	const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
											vec2(  0.0000,  0.2500 ),
											vec2( -0.2165,  0.1250 ),
											vec2( -0.2165, -0.1250 ),
											vec2( -0.0000, -0.2500 ),
											vec2(  0.2165, -0.1250 ),
											vec2(  0.4330,  0.2500 ),
											vec2(  0.0000,  0.5000 ),
											vec2( -0.4330,  0.2500 ),
											vec2( -0.4330, -0.2500 ),
											vec2( -0.0000, -0.5000 ),
											vec2(  0.4330, -0.2500 ),
											vec2(  0.6495,  0.3750 ),
											vec2(  0.0000,  0.7500 ),
											vec2( -0.6495,  0.3750 ),
											vec2( -0.6495, -0.3750 ),
											vec2( -0.0000, -0.7500 ),
											vec2(  0.6495, -0.3750 ),
											vec2(  0.8660,  0.5000 ),
											vec2(  0.0000,  1.0000 ),
											vec2( -0.8660,  0.5000 ),
											vec2( -0.8660, -0.5000 ),
											vec2( -0.0000, -1.0000 ),
											vec2(  0.8660, -0.5000 ),
											vec2(  0.2163,  0.3754 ),
											vec2( -0.2170,  0.3750 ),
											vec2( -0.4333, -0.0004 ),
											vec2( -0.2163, -0.3754 ),
											vec2(  0.2170, -0.3750 ),
											vec2(  0.4333,  0.0004 ),
											vec2(  0.4328,  0.5004 ),
											vec2( -0.2170,  0.6250 ),
											vec2( -0.6498,  0.1246 ),
											vec2( -0.4328, -0.5004 ),
											vec2(  0.2170, -0.6250 ),
											vec2(  0.6498, -0.1246 ),
											vec2(  0.6493,  0.6254 ),
											vec2( -0.2170,  0.8750 ),
											vec2( -0.8663,  0.2496 ),
											vec2( -0.6493, -0.6254 ),
											vec2(  0.2170, -0.8750 ),
											vec2(  0.8663, -0.2496 ),
											vec2(  0.2160,  0.6259 ),
											vec2( -0.4340,  0.5000 ),
											vec2( -0.6500, -0.1259 ),
											vec2( -0.2160, -0.6259 ),
											vec2(  0.4340, -0.5000 ),
											vec2(  0.6500,  0.1259 ),
											vec2(  0.4325,  0.7509 ),
											vec2( -0.4340,  0.7500 ),
											vec2( -0.8665, -0.0009 ),
											vec2( -0.4325, -0.7509 ),
											vec2(  0.4340, -0.7500 ),
											vec2(  0.8665,  0.0009 ),
											vec2(  0.2158,  0.8763 ),
											vec2( -0.6510,  0.6250 ),
											vec2( -0.8668, -0.2513 ),
											vec2( -0.2158, -0.8763 ),
											vec2(  0.6510, -0.6250 ),
											vec2(  0.8668,  0.2513 ));
											
	const vec2 offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
const vec2 fast_offsets[20] = vec2[20](vec2(1,0),
									vec2(-1,0),
									vec2(0,1),
									vec2(0,-1),
									vec2(0.7,0.7),
									vec2(-0.7,0.7),
									vec2(0.7,-0.7),
									vec2(-0.7,-0.7),
									vec2(0.5,0),
									vec2(-0.5,0),
									vec2(0,0.5),
									vec2(0,-0.5),
									vec2(0.35,0.35),
									vec2(-0.35,0.35),
									vec2(0.35,-0.35),
									vec2(-0.35,-0.35),
									vec2(0.25,0),
									vec2(-0.25,0),
									vec2(0,0.25),
									vec2(0,-0.25)
									);	

vec3 Uncharted2Tonemap(vec3 x) {
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	float W = MAX_COLOR_RANGE;
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

float distratio(vec2 pos, vec2 pos2) {
	float xvect = pos.x*aspectRatio-pos2.x*aspectRatio;
	float yvect = pos.y-pos2.y;
	return sqrt(xvect*xvect + yvect*yvect);
}
								
float gen_circular_lens(vec2 center, float size) {
	float dist=distratio(center,texcoord.xy)/size;
	return exp(-dist*dist);
}

vec2 noisepattern(vec2 pos) {
	return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}


float distratio(vec2 pos, vec2 pos2, float ratio) {
	float xvect = pos.x*ratio-pos2.x*ratio;
	float yvect = pos.y-pos2.y;
	return sqrt(xvect*xvect + yvect*yvect);
}

float yDistAxis (in float degrees) {
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		 lightPos = (lightPos + 1.0f)/2.0f;
		 
	return abs((lightPos.y-lightPos.x*(degrees))-(texcoord.y-texcoord.x*(degrees)));
	
}

float smoothCircleDist (in float lensDist) {
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z*lensDist;
		 lightPos = (lightPos + 1.0f)/2.0f;
		 
	return distratio(lightPos.xy, texcoord.xy, aspectRatio);
	
}

float cirlceDist (float lensDist, float size) {

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z*lensDist;
		 lightPos = (lightPos + 1.0f)/2.0f;
		 
	return pow(min(distratio(lightPos.xy, texcoord.xy, aspectRatio),size)/size,10.);
}


vec3 alphablend(vec3 c, vec3 ac, float a) {
vec3 n_ac = normalize(ac)*(1/sqrt(3.));
vec3 nc = sqrt(c*n_ac);
return mix(c,nc,a);
}
float smStep (float edge0,float edge1,float x) {
float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
return t * t * (3.0 - 2.0 * t);
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {


		const float pi = 3.14159265359;
		float rainlens = 0.0;
		const float lifetime = 4.0;		//water drop lifetime in seconds
		float ftime = frametime*2.0/lifetime;  
		vec2 drop = vec2(0.0,fract(frametime/10.0));

		if (rainStrength > 0.02) {
		float gen = 1.0-fract((ftime+0.5)*0.5);
		vec2 pos = (noisepattern(vec2(-0.94386347*floor(ftime*0.5+1.0),floor(ftime*0.5+1.0))))*0.8+0.1 - drop;
		rainlens += gen_circular_lens(fract(pos),0.04)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.0)*0.5);
		pos = (noisepattern(vec2(0.9347*floor(ftime*0.5+0.5),-1.033282*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.023)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.5)*0.5);
		pos = (noisepattern(vec2(0.785282*floor(ftime*0.5+0.75),-0.285282*floor(ftime*0.5+0.75))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.03)*gen*rainStrength;

		gen =  1.0-fract(ftime*0.5);
		pos = (noisepattern(vec2(-0.347*floor(ftime*0.5),0.6847*floor(ftime*0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.05)*gen*rainStrength;
	
		rainlens *= clamp((eyeBrightnessSmooth.y-220.0)/15.0,0.0,1.0);
	}
	vec2 fake_refract = (texture2D(noisetex,(texcoord.xy+frameTimeCounter/32)/32*vec2(1.0,aspectRatio)).xy-texture2D(noisetex,(texcoord.xy+frameTimeCounter/32)/24*vec2(1.0,aspectRatio)).xy)*1.5;
	vec2 newTC = texcoord.st + fake_refract * 0.01 * (rainlens*2+isEyeInWater*0.25);
	
	vec3 color = pow(texture2D(gaux2, newTC).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	vec3 aux = texture2D(gaux1, newTC).rgb;
	
	float hand  = float(aux.g > 0.75 && aux.g < 0.85);
	float land = float(aux.g > 0.04);
	
	float fogrange = ((Blur_Distance*(7.0-3.5*rainStrength))/(1+rainStrength*eyeBrightnessSmooth.y/240.0)*(1-isEyeInWater) + isEyeInWater);
	if (dimread == -1 || dimread == 1) fogrange *= 2;
	vec3 uPos  = nvec3(gbufferProjectionInverse * nvec4(vec3(newTC.xy,texture2D(depthtex1,newTC.xy).x) * 2.0 - 1.0));	
	float fog = max((length(uPos)-fogrange)/1024,0.0);
	
float pcoc = 0;	
#ifdef DOF
	float z = texture2D(depthtex2, newTC.st).r;
	float focus = centerDepthSmooth;
	float blursize = DOF_BlurSize*viewWidth/1280;
	pcoc = clamp(abs(z-focus)/16*blursize/4,0,pw*blursize);
	//pcoc -= hand*0.025;
	
	#ifdef DOF_DistantBlur
	pcoc = min((fog*pw*(land*(1-rainStrength)+rainStrength))*sizemult,pw*blursize);
	#endif
	
	#ifdef DOF_DualBlur
	if (dimread == 0){
		pcoc = clamp(pcoc + min((fog*pw*(land*(1-rainStrength)+rainStrength))*sizemult,pw*blursize),0,pw*blursize);
		}
	else
	{
		pcoc = clamp(pcoc + min(fog*pw*sizemult,pw*blursize),0,pw*blursize);
	}
	#endif
	
	#ifndef DOF_HandBlur
	pcoc = pcoc*(1-hand);
	#endif
	
	float w = 0;
	float allw = 0;
	vec3 bcolor = color/MAX_COLOR_RANGE;
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);
	float abberationoffset = ChromaticAbberation_Strength;
	
{
	if (pcoc > pw*0.5) {
	#ifdef ChromaticAbberation
			#ifdef DOF_BokehHexagon
			for ( int i = 0; i < 60; i++) {
			w = 1-pow(length(hex_offsets[i]),2.0);
			bcolor.r += pow(texture2D(gaux2, newTC.xy + (hex_offsets[i]-vec2(abberationoffset,0.0))*pcoc*vec2(1.0,aspectRatio)).r,2.2)*w;
			bcolor.g += pow(texture2D(gaux2, newTC.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio)).g,2.2)*w;
			bcolor.b += pow(texture2D(gaux2, newTC.xy + (hex_offsets[i]+vec2(abberationoffset,0.0))*pcoc*vec2(1.0,aspectRatio)).b,2.2)*w;
			allw += w;
			}
			color.rgb = bcolor/(allw+1)*MAX_COLOR_RANGE;
		#endif
		#ifdef DOF_BokehCircleLow
		for ( int i = 0; i < 20; i++) {
			w = 1-pow(length(fast_offsets[i]),2.0);
			bcolor.r += pow(texture2D(gaux2, newTC.xy + (fast_offsets[i]-vec2(abberationoffset,0.0))*pcoc*vec2(1.0,aspectRatio)).r,2.2)*w;
			bcolor.g += pow(texture2D(gaux2, newTC.xy + fast_offsets[i]*pcoc*vec2(1.0,aspectRatio)).g,2.2)*w;
			bcolor.b += pow(texture2D(gaux2, newTC.xy + (fast_offsets[i]+vec2(abberationoffset,0.0))*pcoc*vec2(1.0,aspectRatio)).b,2.2)*w;
			allw += w;
			}
			color.rgb = bcolor/(allw+1)*MAX_COLOR_RANGE;
		#endif
		#ifdef DOF_BokehCircle
		for ( int i = 0; i < 60; i++) {
			w = 1-pow(length(offsets[i]),2.0);
			bcolor.r += pow(texture2D(gaux2, newTC.xy + (offsets[i]-vec2(abberationoffset,0.0))*pcoc*vec2(1.0,aspectRatio)).r,2.2)*w;
			bcolor.g += pow(texture2D(gaux2, newTC.xy + offsets[i]*pcoc*vec2(1.0,aspectRatio)).g,2.2)*w;
			bcolor.b += pow(texture2D(gaux2, newTC.xy + (offsets[i]+vec2(abberationoffset,0.0))*pcoc*vec2(1.0,aspectRatio)).b,2.2)*w;
			allw += w;
			}
			color.rgb = bcolor/(allw+1)*MAX_COLOR_RANGE;
		#endif
	#else
		#ifdef DOF_BokehHexagon
			for ( int i = 0; i < 60; i++) {
			w = 1-pow(length(hex_offsets[i]),2.0);
			bcolor += pow(texture2D(gaux2, newTC.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2))*w;
			allw += w;
			}
			color.rgb = bcolor/(allw+1)*MAX_COLOR_RANGE;
		#endif
		#ifdef DOF_BokehCircleLow
		for ( int i = 0; i < 20; i++) {
			w = 1-pow(length(fast_offsets[i]),2.0);
			bcolor += pow(texture2D(gaux2, newTC.xy + fast_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2))*w;
			allw += w;
			}
			color.rgb = bcolor/(allw+1)*MAX_COLOR_RANGE;
		#endif
		#ifdef DOF_BokehCircle
		for ( int i = 0; i < 60; i++) {
			w = 1-pow(length(offsets[i]),2.0);
			bcolor += pow(texture2D(gaux2, newTC.xy + offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2))*w;
			allw += w;
			}
			color.rgb = bcolor/(allw+1)*MAX_COLOR_RANGE;
		#endif
	#endif
	}	
	}
#endif

#ifdef MotionBlur
	
	vec4 motionblur  = texture2D(depthtex2, newTC.st);
	vec3 mblur = pow(texture2D(gaux2,newTC.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	
	vec4 currentPosition = vec4(newTC.x * 2.0 - 1.0, newTC.y * 2.0 - 1.0, 2.0 * motionblur.x - 1.0, 1.0);
	
	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;
	
	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;

	vec2 velocity = (currentPosition - previousPosition).st * MotionBlur_Strength / MotionBlur_Pass;
	float velocitylimit = MotionBlur_Strength*0.05;
	velocity = clamp(velocity,-velocitylimit,velocitylimit);

	vec2 coord = newTC.st + velocity;
	for (int i = 0; i < MotionBlur_Pass; ++i, coord += velocity) {
		if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0 || hand > 0.9)
		mblur += pow(texture2D(gaux2, newTC).rgb,vec3(2.2))*MAX_COLOR_RANGE;
		if (hand < 0.9)
		mblur += pow(texture2D(gaux2, coord).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	}
	mblur /= (MotionBlur_Pass+1);
float pcoc1 = clamp(pcoc/2,0,pw*2)/pw/2;
color.rgb = color*pcoc1 + mblur.rgb*(1-pcoc1);
//color = vec3(pcoc1);
#endif

#ifdef Bloom

vec3 blur = vec3(0);
vec2 bloomcoord = texcoord.xy;

	vec3 blur1 = pow(texture2D(composite,bloomcoord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb,vec3(2.2))*pow(7.0,1.0);
	vec3 blur2 = pow(texture2D(composite,bloomcoord/pow(2.0,3.0) + vec2(0.3,0.0)).rgb,vec3(2.2))*pow(6.0,1.0);
	vec3 blur3 = pow(texture2D(composite,bloomcoord/pow(2.0,4.0) + vec2(0.0,0.3)).rgb,vec3(2.2))*pow(5.0,1.0);
	vec3 blur4 = pow(texture2D(composite,bloomcoord/pow(2.0,5.0) + vec2(0.1,0.3)).rgb,vec3(2.2))*pow(4.0,1.0);
	vec3 blur5 = pow(texture2D(composite,bloomcoord/pow(2.0,6.0) + vec2(0.2,0.3)).rgb,vec3(2.2))*pow(3.0,1.0);
	vec3 blur6 = pow(texture2D(composite,bloomcoord/pow(2.0,7.0) + vec2(0.3,0.3)).rgb,vec3(2.2))*pow(2.0,1.0);
	blur = blur1 + blur2 + blur3 + blur4 + blur5 + blur6;
	//blur = blur*pow(length(blur),0.4);
	//blur = pow(texture2D(composite,bloomcoord/2).rgb,vec3(2.2));

color.rgb = mix(color,blur*MAX_COLOR_RANGE,0.003*Bloom_Strength);
//color = blur*MAX_COLOR_RANGE;
//color.rgb = blur5;
#endif

	color.xyz = ((1-(1-color.xyz/48.0)*(1-(color.rgb/48.0)*sqrt(luma(color.rgb/48.0))))*48.0);


	//draw rain
	vec4 rain = pow(texture2D(gaux4,newTC.xy),vec4(vec3(2.2),0.4));
	color.rgb = alphablend(color,color,rain.a*0.2*(1-hand));

	//rain drops on screen
	vec3 c_rain = color*1.5;
	color = mix(color,c_rain,pow(rainlens,0.5)*rainStrength);
	
	//Tonemapping
	vec3 curr = Uncharted2Tonemap(color);
	
	vec3 whiteScale = 1.0f/Uncharted2Tonemap(vec3(MAX_COLOR_RANGE));
	color = curr*whiteScale;
	
		
	//Vignette
	#ifdef Vignette
	float len = length(texcoord.xy-vec2(.5));
	float len2 = distratio(texcoord.xy,vec2(.5));
	float dc = mix(len,len2,0.3);
    float vignette = smStep(Vignette_End, Vignette_Start,  dc);
	
	color = mix(color,color*vignette,Vignette_Strength);
	#endif
	
	
	//Lens Flare
	#ifdef LensFlare
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;

    float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

    float time = float(worldTime);

    float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a,1.0) * fading ;
	float sunvisibility2 = min(texture2D(gaux2,vec2(0.0)).a,1.0);
	float centerVisibility = 1.0 - clamp(distance(lightPos.xy, vec2(0.5, 0.5)) * 2.0, 0.0, 1.0);
		  centerVisibility *= sunvisibility;
	
	// Fix, that the particles are visible on the moon position at daytime
	float truepos = sign(sunPosition.z);		//1 -> sun / -1 -> moon
	vec3 rainc = mix(vec3(1.),vec3(0.2,1.0,0.3),rainStrength);
	vec3 lightColor = mix(sunlight*sunVisibility*rainc,12.0*moonlight*moonVisibility*rainc,truepos*0.5+0.5);
	
	float lensBrightness = 1.2*Lens_Strength;
	#ifndef LensFlare_Sun
	lensBrightness *= max(truepos,0.0);
	#endif
	#ifndef LensFlare_Moon
	lensBrightness *= max(-truepos,0.0);
	#endif
	
	// Anamorphic Lens
	if (sunvisibility > 0.01) {
		
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.5,0.1),1.0)-0.1,0.0);
		
			
		vec3 lenscolor = length(lightColor)*vec3(0.2, 0.4, 1.25)*(1+moonVisibility)/2;

		float lens_strength = 0.8 * lensBrightness;
		lenscolor *= lens_strength;
		
		float anamorphic_lens = max(pow(max(1.0 - yDistAxis(0.0)/1.4,0.1),10.0),0.0);
		color += anamorphic_lens * lenscolor * visibility  * sunvisibility * (1.0-rainStrength*1.0);
		
		//Sun Glow
		if (length(lightColor) > 0.001)
		lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor)*vec3(0.7,0.75,1.);

			
		lens_strength = 0.6 * lensBrightness;
		lenscolor *= lens_strength;
		
		float lensFlare = max(pow(max(1.0 - smoothCircleDist(1.0)/2.4,0.1),5.0)-0.1,0.0);
			
		//color += lensFlare * lenscolor * sunvisibility2 * (1.0-rainStrength*1.0);
		
		
				// Circle Lens 1
		
		
			lenscolor =  vec3(2.52, 1.8, 0.4) * lightColor;
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			float lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.15, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			float lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.2, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			float lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.25, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		
		// Circle Lens 2
		
		
			lenscolor =  vec3(0.7, 2.55, 0.4) * lightColor;
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.4, 0.13)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.5, 0.13)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.6, 0.13)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		
		// Circle Lens 3
		
		
			lenscolor =  vec3(0.4, 1.95, 2.55) * lightColor;
			
			lens_strength = 0.1 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.75, 0.09)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.8, 0.09)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.85, 0.09)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		
		
		// Small point 1

		
			lenscolor = vec3(2.55, 2.55, 0.0) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.27)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.3)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.33)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);
		
		// Small point 2
		
		
			lenscolor = vec3(0.0, 2.55, 1.52) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.62)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.65)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.68)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);
		
		
		// Ring Lens 

		
			lenscolor = vec3(0.2, 0.8, 2.55) * length(lightColor);
			
			lens_strength = 0.3 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.7, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.9, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
		
		
	}
	#endif
		
	color = clamp(pow(color,vec3(1.0/2.2)),0.0,1.0);
	
	#ifdef Old_School
	if (length(color) < 0.5)color = normalize(color)*floor(length(color*Old_School_Limit))/Old_School_Limit;
	if (length(color) > 0.5)color = normalize(color)*ceil(length(color*Old_School_Limit))/Old_School_Limit;
	#endif
	
	color = color*Color_Brightness;
	color = color*(Color_Saturation)-(color.r+color.g+color.b)/3*(Color_Saturation-1);
	
	#ifdef Temperature
	vec3 temprawcol = color;
	#ifdef Temperature_Cold
	temprawcol = vec3(0.2,0.5,1.2);
	#endif
	#ifdef Temperature_Hot
	temprawcol = vec3(1.2,1.1,0.7);
	#endif
	vec3 tmpcolor = clamp(length(color),0,1)*temprawcol;
	color = mix(color,tmpcolor,Temperature_Strength);
	#endif
	
	gl_FragColor = vec4(color,1.0);
}

