#version 120

#define EXPOSURE_MULTIPLIER 1.0 //[0.25 0.4 0.5 0.6 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.1 1.2 1.3 1.4 1.5 2.0 3.0 4.0]

uniform sampler2D gaux1;

varying vec2 texcoord;
varying vec4 fogColor;
varying vec3 exposure;
varying vec3 wsunVec;

uniform int isEyeInWater;

uniform float moonIntensity;
uniform float skyIntensity;
uniform float skyIntensityNight;
uniform float rainStrength;
uniform float sunIntensity;
uniform float fogAmount;

uniform vec2 texelSize;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform vec3 sunVec;
uniform vec3 nsunColor;
uniform vec4 lightCol;
uniform mat4 gbufferModelViewInverse;

#include "lib/sky_gradient.glsl"
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	wsunVec = mat3(gbufferModelViewInverse)*sunVec;
	fogColor.rgb = getSkyColorLut(wsunVec*0.85+vec3(0.0,0.15,0.0),wsunVec,0.15+wsunVec.y*0.85,gaux1)*(eyeBrightness.y/255.+0.006)*10.;
	fogColor.a = 0.3*fogAmount;

	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.xy;
	float avgEyeIntensity = ((sunIntensity*3.0+moonIntensity*0.001)*16.+(skyIntensity+skyIntensityNight*0.001)*8.)*pow(eyeBrightnessSmooth.y/255.,2.4) +0.02;
	exposure = EXPOSURE_MULTIPLIER*0.06*pow(avgEyeIntensity,-1./3.2)*(0.61*vec3(1.0,0.87,0.78));

	if (isEyeInWater == 1){
		fogColor.rgb = (lightCol.g + skyIntensity + skyIntensityNight)*vec3(0.06,0.27,0.35)/length(exposure)*0.015;
		fogColor.a = 0.06;
	}

}
