#version 120

#define TONEMAP_ACES



varying vec4 fogColor;
varying vec3 wsunVec;
varying vec2 texcoord;
varying vec3 exposure;

uniform sampler2D depthtex0;
uniform sampler2D colortex1;
uniform sampler2D gaux1;
uniform sampler2D shadow;
uniform int isEyeInWater;
uniform float rainStrength;
uniform ivec2 eyeBrightness;
uniform vec2 texelSize;
uniform mat4 gbufferProjectionInverse;

#include "lib/color_transforms.glsl"
#include "lib/sky_gradient.glsl"

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

vec3 toScreenSpace(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}
float interleaved_gradientNoise(){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y));
}
vec3 int8Dither(vec3 color){
	float dither = interleaved_gradientNoise();
	return color + dither*exp2(-8.0);
}


void main() {
/* DRAWBUFFERS:0 */
	vec3 color = texture2D(colortex1,texcoord).rgb;


	float z = texture2D(depthtex0,texcoord).x;
		if (z < 1.0 || isEyeInWater == 1){
			vec3 fragpos = toScreenSpace(vec3(texcoord,z));
			float dist = length(fragpos);

			float fogFactorScat = exp(-dist*fogColor.a);

			color.rgb = mix(fogColor.rgb,color,fogFactorScat);
			}


	//tonemap
	#ifndef TONEMAP_ACES
		gl_FragData[0].rgb = int8Dither(Uncharted2Tonemap(exposure*color)/Uncharted2Tonemap(vec3(11.2)));
	#endif
	#ifdef TONEMAP_ACES
		gl_FragData[0].rgb = int8Dither(ACESFilm(exposure*color));
	#endif
	//gl_FragData[0].rgb = texture2D(gaux1,texcoord).rgb/10.;
//	gl_FragData[0].rgb = texture2D(shadow,texcoord).rgb;

}
