#version 150

in vec3 Position;
in vec2 UV0;
in vec4 Offset;
in vec4 OffsetNew;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform float RenderPercent;
uniform vec3 RippleCameraPos;

out vec2 texCoord0;
out float transparency;

void main() {
	float scale = OffsetNew.w;
	vec4 currentWorldPos = ModelViewMat * vec4(Position.xyz * scale + mix(Offset.xyz, OffsetNew.xyz, RenderPercent) - RippleCameraPos, 1.0);
    gl_Position = ProjMat * currentWorldPos;

    texCoord0 = UV0;
    transparency = Offset.w;
}
