/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.network.message;

import com.craftix.hostile_humans.entity.HumanCommand;
import com.craftix.hostile_humans.entity.HumanEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MessageCommandHuman {
    protected final String humanMobEntityUUID;
    protected final String command;

    public MessageCommandHuman(String humanMobEntityUUID, String command) {
        this.humanMobEntityUUID = humanMobEntityUUID;
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getHHFollowerUUID() {
        return this.humanMobEntityUUID;
    }

    public static void handle(MessageCommandHuman message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageCommandHuman.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageCommandHuman message, NetworkEvent.Context context) {
        UUID uuid;
        ServerPlayer serverPlayer = context.getSender();
        ServerLevel serverLevel = serverPlayer.m_183503_();
        Entity entity = serverLevel.m_8791_(uuid = UUID.fromString(message.getHHFollowerUUID()));
        if (entity instanceof HumanEntity) {
            HumanEntity humanEntity = (HumanEntity)entity;
            HumanCommand command = HumanCommand.valueOf(message.getCommand());
            if (serverPlayer.m_142081_().equals(humanEntity.m_142504_())) {
                humanEntity.handleCommand(command);
            }
        }
    }
}

