/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.network;

import com.craftix.hostile_humans.network.message.MessageCommandHuman;
import com.craftix.hostile_humans.network.message.MessageHumanData;
import com.craftix.hostile_humans.network.message.MessageHumansData;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber
public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("hostile_humans", "network"), () -> "2", "2"::equals, "2"::equals);
    private static final ConcurrentHashMap<UUID, ServerPlayer> serverPlayerMap = new ConcurrentHashMap();
    private static int id = 0;
    private static CompoundTag lastHumanMobDataPackage;
    private static CompoundTag lastHumanMobsDataPackage;

    protected NetworkHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        NetworkHandler.addServerPlayer(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkHandler.addServerPlayer(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        NetworkHandler.removeServerPlayer(event.getPlayer());
    }

    public static void registerNetworkHandler(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            INSTANCE.registerMessage(id++, MessageCommandHuman.class, (message, buffer) -> {
                buffer.m_130070_(message.getHHFollowerUUID());
                buffer.m_130070_(message.getCommand());
            }, buffer -> new MessageCommandHuman(buffer.m_130277_(), buffer.m_130277_()), MessageCommandHuman::handle);
            INSTANCE.registerMessage(id++, MessageHumansData.class, (message, buffer) -> buffer.m_130079_(message.data()), buffer -> new MessageHumansData(buffer.m_130260_()), MessageHumansData::handle);
            INSTANCE.registerMessage(id++, MessageHumanData.class, (message, buffer) -> {
                buffer.m_130070_(message.getHHFollowerUUID());
                buffer.m_130079_(message.getData());
            }, buffer -> new MessageHumanData(buffer.m_130277_(), buffer.m_130260_()), MessageHumanData::handle);
        });
    }

    public static void updateHHFollowersData(UUID ownerUUID, CompoundTag humanMobsData) {
        if (ownerUUID != null && humanMobsData != null && !humanMobsData.m_128456_() && !humanMobsData.equals((Object)lastHumanMobsDataPackage)) {
            ServerPlayer serverPlayer = NetworkHandler.getServerPlayer(ownerUUID);
            if (serverPlayer == null) {
                return;
            }
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageHumansData(humanMobsData));
            lastHumanMobsDataPackage = humanMobsData;
        }
    }

    public static void updateHHFollowerData(UUID humanMobEntityUUID, UUID ownerUUID, CompoundTag humanMobData) {
        if (humanMobEntityUUID != null && ownerUUID != null && humanMobData != null && !humanMobData.m_128456_() && !humanMobData.equals((Object)lastHumanMobDataPackage)) {
            ServerPlayer serverPlayer = NetworkHandler.getServerPlayer(ownerUUID);
            if (serverPlayer == null) {
                return;
            }
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageHumanData(humanMobEntityUUID.toString(), humanMobData));
            lastHumanMobDataPackage = humanMobData;
        }
    }

    public static void addServerPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.addServerPlayer(serverPlayer.m_142081_(), serverPlayer);
        }
    }

    public static void addServerPlayer(UUID uuid, ServerPlayer serverPlayer) {
        serverPlayerMap.put(uuid, serverPlayer);
    }

    public static void removeServerPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.removeServerPlayer(serverPlayer.m_142081_());
        }
    }

    public static void removeServerPlayer(UUID uuid) {
        serverPlayerMap.remove(uuid);
    }

    public static ServerPlayer getServerPlayer(UUID uuid) {
        return serverPlayerMap.get(uuid);
    }
}

