/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.spawner;

import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.human.Human;
import com.craftix.hostile_humans.entity.human.ModEntityType;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber
public class SpawnHandler {
    protected SpawnHandler() {
    }

    @SubscribeEvent
    public static void onWorldLoad(ServerAboutToStartEvent event) {
    }

    @SubscribeEvent
    public static void handleBiomeLoadingEvent(BiomeLoadingEvent event) {
        ResourceLocation biomeRegistry = event.getName();
        if (biomeRegistry == null) {
            return;
        }
        event.getSpawns().getSpawner(HumanEntity.CATEGORY).add(new MobSpawnSettings.SpawnerData((EntityType)ModEntityType.ROAMER.get(), 1, 1, 1));
    }

    public static void registerSpawnPlacements(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityType.ROAMER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnHandler::checkHumanSpawnRules));
    }

    public static boolean checkHumanSpawnRules(EntityType<? extends Human> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, Random p_33022_) {
        return SpawnHandler.isBrightEnoughToSpawn(p_33019_, p_33021_, p_33022_) && Mob.m_21400_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (Random)p_33022_);
    }

    public static boolean isBrightEnoughToSpawn(ServerLevelAccessor p_33009_, BlockPos p_33010_, Random p_33011_) {
        return p_33009_.m_45517_(LightLayer.SKY, p_33010_) > p_33011_.nextInt(90) + 10;
    }
}

