/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.human;

import com.craftix.hostile_humans.compat.ImmersiveArmors;
import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.ai.goal.BowAttack;
import com.craftix.hostile_humans.entity.ai.goal.CrossbowGoal;
import com.craftix.hostile_humans.entity.ai.goal.MeleeAttackGoal;
import com.craftix.hostile_humans.entity.ai.goal.NearestAttackableTargetGoalCustom;
import com.craftix.hostile_humans.entity.ai.goal.RaiseShieldGoal;
import com.craftix.hostile_humans.entity.ai.goal.RandomStrollGoalCustom;
import com.craftix.hostile_humans.entity.human.Roamer;
import com.craftix.hostile_humans.entity.type.human.HumanWalking;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.ModList;

public class Human
extends HumanWalking
implements RangedAttackMob,
CrossbowAttackMob {
    private static final UUID MODIFIER_UUID = UUID.fromString("7a0811af-4025-4691-ba75-2d638d4ab3f4");
    private static final AttributeModifier USE_ITEM_SPEED_PENALTY = new AttributeModifier(MODIFIER_UUID, "Use item speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    public int shieldCoolDown;
    private static final Map<String, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        for (int i = 1; i <= 17; ++i) {
            String name = "skin" + i;
            hashMap.put(name, new ResourceLocation("hostile_humans", "textures/entity/human/" + name + ".png"));
        }
    });
    private final CrossbowGoal<Human> crossbowAttackGoal = new CrossbowGoal<Human>(this, 1.0, 15.0f);
    private final BowAttack<Human> bowAttackGoal = new BowAttack<Human>(this, 1.0, 80, 15.0f);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal(this, 1.05, true);
    public static int[] tier1Armor = new int[]{0, 2, 3, 1};
    public static int[] tier2Armor = new int[]{2, 3, 4};
    public static Item[] tier1Weapons = new Item[]{Items.f_42383_, Items.f_42425_, Items.f_42383_, Items.f_42425_, Items.f_42717_, Items.f_42411_};
    public static Item[] tier2Weapons = new Item[]{Items.f_42388_, Items.f_42391_, Items.f_42388_, Items.f_42391_, Items.f_42717_, Items.f_42411_};
    public static Item[] rangedWeapons = new Item[]{Items.f_42717_, Items.f_42411_};
    private static final Ingredient EDIBLE_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42400_, Items.f_42406_, Items.f_42485_, Items.f_42486_, Items.f_42436_, Items.f_42437_, Items.f_42526_, Items.f_42527_, Items.f_42528_, Items.f_42529_, Items.f_42530_, Items.f_42531_, Items.f_42572_, Items.f_42575_, Items.f_42579_, Items.f_42580_, Items.f_42581_, Items.f_42582_, Items.f_42583_, Items.f_42591_, Items.f_42619_, Items.f_42620_, Items.f_42674_, Items.f_42675_, Items.f_42677_, Items.f_42687_, Items.f_42697_, Items.f_42698_, Items.f_42699_, Items.f_42658_, Items.f_42659_, Items.f_42730_, Items.f_42732_, Items.f_42734_, Items.f_42576_, Items.f_42718_, Items.f_42780_, Items.f_42787_, Items.f_151079_});

    public Human(EntityType<? extends HumanEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21553_(true);
        this.m_6593_(null);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_VARIANT.get(this.getVariant());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(-1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(-1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(-1, (Goal)new RaiseShieldGoal(this));
        if (this instanceof Roamer) {
            this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoalCustom((PathfinderMob)this, 0.65, 15, false));
        } else {
            this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.65, 120, true));
        }
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, new NearestAttackableTargetGoalCustom<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, this::isAngryAt));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void setCombatTask() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_(this.bowAttackGoal);
            this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
            this.f_21345_.m_25363_(this.crossbowAttackGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, this::canFireProjectileWeapon));
            if (itemstack.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(1, this.crossbowAttackGoal);
            } else if (itemstack.m_41720_() instanceof BowItem) {
                this.bowAttackGoal.setMinAttackInterval(40);
                this.f_21345_.m_25352_(1, this.bowAttackGoal);
            } else {
                this.f_21345_.m_25352_(1, (Goal)this.meleeAttackGoal);
            }
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean result = super.m_7327_(entityIn);
        this.m_6674_(InteractionHand.MAIN_HAND);
        return result;
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn)) {
            this.disableShield(true);
        }
    }

    public void disableShield(boolean increase) {
        float chance = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.f_19796_.nextFloat() < chance) {
            this.shieldCoolDown = 100;
            this.m_5810_();
            this.f_19853_.m_7605_((Entity)this, (byte)30);
        }
    }

    public SoundEvent m_7866_(ItemStack p_21202_) {
        return SoundEvents.f_12321_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        ArrayList<String> variants = new ArrayList<String>(TEXTURE_BY_VARIANT.keySet());
        this.setVariant((String)variants.get(this.f_19796_.nextInt(variants.size())));
        this.m_21553_(true);
        return spawnGroupData;
    }

    @Override
    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        if (!this.f_19853_.f_46443_) {
            this.setCombatTask();
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        if (this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return super.m_7975_(damageSourceIn);
    }

    protected void m_7909_(float damage) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && damage >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)damage);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, entity -> entity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
            }
        }
    }

    public void m_6672_(InteractionHand hand) {
        super.m_6672_(hand);
        ItemStack itemstack = this.m_21120_(hand);
        if (itemstack.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            modifiableattributeinstance.m_22130_(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.m_22118_(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void m_5810_() {
        super.m_5810_();
        if (this.m_21051_(Attributes.f_22279_).m_22109_(USE_ITEM_SPEED_PENALTY)) {
            this.m_21051_(Attributes.f_22279_).m_22130_(USE_ITEM_SPEED_PENALTY);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCombatTask();
    }

    public boolean m_6779_(LivingEntity entity) {
        if (!(this instanceof Roamer) && entity instanceof Human && !(entity instanceof Roamer)) {
            return false;
        }
        return super.m_6779_(entity);
    }

    public boolean isAngryAt(LivingEntity entity) {
        if (!this.m_6779_(entity)) {
            return false;
        }
        if (entity instanceof AbstractSchoolingFish) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_7500_() && !player.m_5833_();
        }
        if (this.getTier() == 9) {
            return true;
        }
        return entity.m_142081_().equals(this.getPersistentAngerTarget());
    }

    protected void m_6851_(DifficultyInstance p_34692_) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
    }

    private void maybeWearArmor(EquipmentSlot p_34760_, ItemStack p_34761_) {
        if (this.f_19853_.f_46441_.nextFloat() < 0.1f) {
            this.m_8061_(p_34760_, p_34761_);
        }
    }

    @Override
    public void finalizeSpawn() {
        super.finalizeSpawn();
        this.generateInventory(false);
    }

    public void generateInventory(boolean forceRanged) {
        int[] armorPick = tier1Armor;
        Item[] weaponPick = tier1Weapons;
        float enchantChance = 0.3f;
        float armorChance = 0.25f;
        switch (this.getTier()) {
            case 2: {
                armorPick = tier2Armor;
                weaponPick = tier2Weapons;
                enchantChance = 1.0f;
                armorChance = 0.15f;
                break;
            }
            case 9: {
                enchantChance = 1.0f;
                armorChance = 0.2f;
                if (this.f_19796_.nextFloat() < 0.3f) {
                    armorPick = tier2Armor;
                }
                if (!(this.f_19796_.nextFloat() < 0.3f)) break;
                weaponPick = tier2Weapons;
            }
        }
        if (forceRanged) {
            weaponPick = rangedWeapons;
        }
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        ItemStack stack = weaponPick[this.f_19796_.nextInt(weaponPick.length)].m_7968_();
        stack.m_41721_(this.f_19796_.nextInt(stack.m_41776_() - 1));
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        if (this.getTier() == 2 || this.getTier() == 9) {
            float f = this.f_19796_.nextFloat();
            float f2 = this.getTier() == 2 ? 0.7f : 0.3f;
            if (f < f2 && !this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42717_) && !this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42411_)) {
                stack = Items.f_42740_.m_7968_();
                stack.m_41721_(this.f_19796_.nextInt(stack.m_41776_() - 1));
                this.m_8061_(EquipmentSlot.OFFHAND, stack);
            }
        }
        int staticImmersivePick = -1;
        if ((double)this.f_19796_.nextFloat() < 0.6 && ModList.get().isLoaded("immersive_armors")) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int[] nArray = armorPick;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = nArray[i];
                list.add(i2);
            }
            list.addAll(Arrays.asList(5, 6));
            staticImmersivePick = (Integer)list.get(this.f_19796_.nextInt(list.size()));
            if ((staticImmersivePick == 3 || staticImmersivePick == 5) && this.f_19796_.nextFloat() < 0.2f) {
                staticImmersivePick = 2;
            }
        }
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack itemstack = this.m_6844_(equipmentslot);
            if (this.getTier() != 2 && this.f_19796_.nextFloat() < armorChance) continue;
            int pick = armorPick[this.f_19796_.nextInt(armorPick.length)];
            Item item = Human.customGetEquipmentForSlot(equipmentslot, pick);
            if (staticImmersivePick != -1) {
                item = ImmersiveArmors.getItemForSlot(equipmentslot, staticImmersivePick);
            }
            if (item == null) continue;
            ItemStack stack2 = new ItemStack((ItemLike)item);
            int damage = (int)((float)this.f_19796_.nextInt(stack2.m_41776_() - 1) * 1.3f);
            if (damage > stack2.m_41776_()) {
                damage = stack2.m_41776_() - 1;
            }
            stack2.m_41721_(damage);
            this.m_8061_(equipmentslot, stack2);
        }
        this.m_7908_(enchantChance);
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            this.m_21380_(enchantChance, equipmentslot);
        }
    }

    public static Item customGetEquipmentForSlot(EquipmentSlot slot, int level) {
        switch (slot) {
            case HEAD: {
                if (level == 0) {
                    return Items.f_42407_;
                }
                if (level == 1) {
                    return Items.f_42476_;
                }
                if (level == 2) {
                    return Items.f_42464_;
                }
                if (level == 3) {
                    return Items.f_42468_;
                }
                if (level == 4) {
                    return Items.f_42472_;
                }
            }
            case CHEST: {
                if (level == 0) {
                    return Items.f_42408_;
                }
                if (level == 1) {
                    return Items.f_42477_;
                }
                if (level == 2) {
                    return Items.f_42465_;
                }
                if (level == 3) {
                    return Items.f_42469_;
                }
                if (level == 4) {
                    return Items.f_42473_;
                }
            }
            case LEGS: {
                if (level == 0) {
                    return Items.f_42462_;
                }
                if (level == 1) {
                    return Items.f_42478_;
                }
                if (level == 2) {
                    return Items.f_42466_;
                }
                if (level == 3) {
                    return Items.f_42470_;
                }
                if (level == 4) {
                    return Items.f_42474_;
                }
            }
            case FEET: {
                if (level == 0) {
                    return Items.f_42463_;
                }
                if (level == 1) {
                    return Items.f_42479_;
                }
                if (level == 2) {
                    return Items.f_42467_;
                }
                if (level == 3) {
                    return Items.f_42471_;
                }
                if (level != 4) break;
                return Items.f_42475_;
            }
        }
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 220 == 0 && this.m_5448_() == null) {
            if (this.getData() != null) {
                for (ItemStack stack : this.getData().getInventoryItems()) {
                    this.m_21540_(stack);
                }
            } else {
                System.out.println("Missing data? " + this);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        this.m_21203_();
    }

    public boolean m_21540_(ItemStack stack) {
        if (this.m_5448_() != null) {
            return false;
        }
        EquipmentSlot equipmentslot = Human.m_147233_((ItemStack)stack);
        ItemStack itemstack = this.m_6844_(equipmentslot);
        boolean flag = this.m_7808_(stack, itemstack);
        if (flag && this.m_7252_(stack)) {
            double d0 = this.m_21519_(equipmentslot);
            if (!itemstack.m_41619_() && (double)Math.max(this.f_19796_.nextFloat() - 0.1f, 0.0f) < d0) {
                this.getData().storeInventoryItem(itemstack);
            }
            this.m_21468_(equipmentslot, stack);
            this.m_147218_(stack);
            return true;
        }
        return false;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    public Item getTameItem() {
        return Items.f_42415_;
    }

    @Override
    public Ingredient getFoodItems() {
        return EDIBLE_ITEMS;
    }

    public void playSound(SoundEvent se) {
        this.m_5496_(se, this.m_6121_(), 1.0f);
    }

    @Override
    public int m_8100_() {
        return 600;
    }

    public float m_6100_() {
        return 1.0f;
    }

    public void m_6136_(boolean pIsCharging) {
        this.setCharging(pIsCharging);
    }

    public boolean canFireProjectileWeapon(Item item) {
        ProjectileWeaponItem weaponItem;
        return item instanceof ProjectileWeaponItem && this.m_5886_(weaponItem = (ProjectileWeaponItem)item);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile projectile, float angle) {
        this.m_32322_((LivingEntity)this, target, projectile, angle, 1.6f);
    }

    public ItemStack m_6298_(ItemStack p_21272_) {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.shieldCoolDown = 8;
        ItemStack weaponStack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, this::canFireProjectileWeapon));
        if (weaponStack.m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 1.6f);
        } else {
            ItemStack itemstack = this.m_6298_(weaponStack);
            AbstractArrow mobArrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            if (this.m_21205_().m_41720_() instanceof BowItem) {
                mobArrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(mobArrow);
            }
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - mobArrow.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            mobArrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)mobArrow);
        }
    }
}

