/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.data;

import com.craftix.hostile_humans.entity.data.HumanData;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public class HumansClientData {
    private static final ConcurrentHashMap<UUID, HumanData> humanMobEntitiesMap = new ConcurrentHashMap();

    protected HumansClientData() {
    }

    public static void load(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("HumanMobs")) {
            ListTag humanMobListTag = compoundTag.m_128437_("HumanMobs", 10);
            for (int i = 0; i < humanMobListTag.size(); ++i) {
                HumansClientData.loadHHFollowerData(humanMobListTag.m_128728_(i));
            }
        } else if (compoundTag.m_128441_("UUID")) {
            HumansClientData.loadHHFollowerData(compoundTag);
        }
    }

    public static void loadHHFollowerData(CompoundTag compoundTag) {
        if (compoundTag != null) {
            UUID humanMobUUID = compoundTag.m_128342_("UUID");
            HumanData humanMobEntityData = humanMobEntitiesMap.get(humanMobUUID);
            if (humanMobEntityData != null) {
                humanMobEntityData.load(compoundTag);
            } else {
                HumanData humanMobEntity = new HumanData(compoundTag);
                HumansClientData.loadHHFollowerData(humanMobEntity);
            }
        }
    }

    public static void loadHHFollowerData(HumanData humanMobEntity) {
        if (humanMobEntity != null) {
            humanMobEntitiesMap.put(humanMobEntity.getUUID(), humanMobEntity);
        }
    }
}

