/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.data;

import com.craftix.hostile_humans.entity.AggressionMode;
import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.data.HumanHelper;
import com.craftix.hostile_humans.entity.data.HumanServerData;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HumanData {
    private static final String ENTITY_AGGRESSION_LEVEL = "EntityAggressionLevel";
    private static final String ENTITY_DATA_TAG = "EntityData";
    private static final String ENTITY_ID_TAG = "EntityId";
    private static final String ENTITY_SITTING_TAG = "EntitySitting";
    private static final String ENTITY_TYPE_TAG = "EntityType";
    private static final String LEVEL_TAG = "Level";
    private static final String NAME_TAG = "Name";
    private static final String OWNER_NAME_TAG = "OwnerName";
    private static final String OWNER_TAG = "Owner";
    private static final String POSITION_TAG = "Position";
    public static final String UUID_TAG = "UUID";
    private AggressionMode entityAggressionLevel = AggressionMode.PASSIVE;
    private BlockPos blockPos;
    private ClientLevel clientLevel;
    private CompoundTag entityData;
    private EntityType<?> entityType;
    private NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> inventoryItems = NonNullList.m_122780_((int)30, (Object)ItemStack.f_41583_);
    private HumanEntity humanMobEntity;
    private ResourceKey<Level> level;
    private ServerLevel serverLevel;
    private String levelName = "";
    private String name = "";
    private String ownerName = "";
    private UUID humanMobUUID = null;
    private UUID ownerUUID = null;
    private boolean entitySitting = false;
    private boolean hasOwner = false;
    private int entityId;

    public HumanData(HumanEntity humanMob) {
        this.load(humanMob);
    }

    public HumanData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public UUID getUUID() {
        return this.humanMobUUID;
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwnerUUID() {
        if (this.ownerUUID == null) {
            return null;
        }
        return this.ownerUUID;
    }

    public HumanEntity getHHFollowerEntity() {
        if (this.humanMobEntity == null) {
            Entity entity = null;
            if (this.serverLevel != null && this.humanMobUUID != null) {
                entity = this.serverLevel.m_8791_(this.humanMobUUID);
            } else if (this.clientLevel != null && this.entityId > 0) {
                entity = this.clientLevel.m_6815_(this.entityId);
            }
            if (entity instanceof HumanEntity) {
                HumanEntity humanEntity;
                this.humanMobEntity = humanEntity = (HumanEntity)entity;
            }
        }
        return this.humanMobEntity;
    }

    public NonNullList<ItemStack> getArmorItems() {
        return this.armorItems;
    }

    public void setArmorItems(NonNullList<ItemStack> armor) {
        this.armorItems = armor;
        this.setDirty();
    }

    public void setArmorItem(int index, ItemStack itemStack) {
        this.armorItems.set(index, (Object)itemStack);
        this.setDirty();
    }

    public NonNullList<ItemStack> getHandItems() {
        return this.handItems;
    }

    public void setHandItems(NonNullList<ItemStack> hand) {
        this.handItems = hand;
        this.setDirty();
    }

    public void setHandItem(int index, ItemStack itemStack) {
        this.handItems.set(index, (Object)itemStack);
        this.setDirty();
    }

    public NonNullList<ItemStack> getInventoryItems() {
        return this.inventoryItems;
    }

    public void setInventoryItem(int index, ItemStack itemStack) {
        this.inventoryItems.set(index, (Object)itemStack);
        this.setDirty();
    }

    public ItemStack getInventoryItem(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }

    public int getInventoryItemsSize() {
        return this.inventoryItems.size();
    }

    public boolean storeInventoryItem(ItemStack itemStack) {
        if (itemStack.m_41741_() > 1) {
            Item item = itemStack.m_41720_();
            int numberOfItems = itemStack.m_41613_();
            for (int index = 0; index < this.getInventoryItemsSize(); ++index) {
                ItemStack existingItems = this.getInventoryItem(index);
                if (existingItems.m_41619_() || !existingItems.m_150930_(item) || existingItems.m_41613_() + numberOfItems >= existingItems.m_41741_()) continue;
                existingItems.m_41769_(numberOfItems);
                return true;
            }
        }
        for (int index = 0; index < this.getInventoryItemsSize(); ++index) {
            ItemStack existingItems = this.getInventoryItem(index);
            if (!existingItems.m_41619_()) continue;
            this.setInventoryItem(index, itemStack);
            return true;
        }
        return false;
    }

    public void load(HumanEntity humanMob) {
        this.humanMobEntity = humanMob;
        this.humanMobUUID = humanMob.m_142081_();
        this.name = humanMob.getCustomHumanMobName();
        this.hasOwner = humanMob.hasOwner();
        if (this.hasOwner) {
            this.ownerUUID = humanMob.m_142504_();
            if (humanMob.m_142480_() != null) {
                this.ownerName = humanMob.m_142480_().m_7755_().getString();
            }
        }
        this.blockPos = humanMob.m_142538_();
        this.level = humanMob.m_183503_().m_46472_();
        this.levelName = this.level.getRegistryName() + "/" + this.level.m_135782_();
        this.entityId = humanMob.m_142049_();
        this.entityAggressionLevel = humanMob.getAggressionLevel();
        this.entityType = humanMob.m_6095_();
        this.entitySitting = humanMob.m_21827_();
        this.entityData = humanMob.serializeNBT();
        Level humanMobLevel = humanMob.m_183503_();
        if (humanMobLevel.f_46443_) {
            this.clientLevel = (ClientLevel)humanMob.m_183503_();
        } else {
            this.serverLevel = (ServerLevel)humanMob.m_183503_();
        }
        this.setArmorItems((NonNullList<ItemStack>)((NonNullList)humanMob.m_6168_()));
        this.setHandItems((NonNullList<ItemStack>)((NonNullList)humanMob.m_6167_()));
    }

    public void load(CompoundTag compoundTag) {
        this.humanMobUUID = compoundTag.m_128342_(UUID_TAG);
        this.name = compoundTag.m_128461_(NAME_TAG);
        this.hasOwner = compoundTag.m_128403_(OWNER_TAG);
        if (this.hasOwner) {
            this.ownerUUID = compoundTag.m_128342_(OWNER_TAG);
            if (compoundTag.m_128441_(OWNER_NAME_TAG)) {
                this.ownerName = compoundTag.m_128461_(OWNER_NAME_TAG);
            }
        }
        this.blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(POSITION_TAG));
        if (compoundTag.m_128441_(LEVEL_TAG)) {
            this.levelName = compoundTag.m_128461_(LEVEL_TAG);
            if (this.levelName.contains("/")) {
                String[] levelNameParts = this.levelName.split("/");
                ResourceLocation registryName = new ResourceLocation(levelNameParts[0]);
                ResourceLocation locationName = new ResourceLocation(levelNameParts[1]);
                this.level = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)registryName), (ResourceLocation)locationName);
            }
        }
        if (compoundTag.m_128441_(ENTITY_ID_TAG)) {
            this.entityId = compoundTag.m_128451_(ENTITY_ID_TAG);
        }
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            this.entityType = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(compoundTag.m_128461_(ENTITY_TYPE_TAG)));
        }
        this.entityData = compoundTag.m_128469_(ENTITY_DATA_TAG);
        this.entitySitting = compoundTag.m_128471_(ENTITY_SITTING_TAG);
        HumanHelper.loadArmorItems(compoundTag, this.armorItems);
        HumanHelper.loadHandItems(compoundTag, this.handItems);
        HumanHelper.loadInventoryItems(compoundTag, this.inventoryItems);
        if (compoundTag.m_128441_(ENTITY_AGGRESSION_LEVEL)) {
            this.entityAggressionLevel = AggressionMode.get(compoundTag.m_128461_(ENTITY_AGGRESSION_LEVEL));
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        return this.save(compoundTag, true);
    }

    public CompoundTag saveMetaData(CompoundTag compoundTag) {
        return this.save(compoundTag, false);
    }

    public CompoundTag save(CompoundTag compoundTag, boolean includeData) {
        compoundTag.m_128362_(UUID_TAG, this.humanMobUUID);
        compoundTag.m_128359_(NAME_TAG, this.name);
        compoundTag.m_128365_(POSITION_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        if (!this.levelName.isEmpty()) {
            compoundTag.m_128359_(LEVEL_TAG, this.levelName);
        }
        compoundTag.m_128405_(ENTITY_ID_TAG, this.entityId);
        compoundTag.m_128359_(ENTITY_TYPE_TAG, this.entityType.getRegistryName().toString());
        HumanEntity humanEntity = this.getHHFollowerEntity();
        if (humanEntity != null && humanEntity.m_6084_()) {
            this.entityData = humanEntity.serializeNBT();
        }
        if (includeData && this.entityData != null) {
            compoundTag.m_128365_(ENTITY_DATA_TAG, (Tag)this.entityData);
        }
        if (humanEntity != null && humanEntity.m_6084_()) {
            compoundTag.m_128379_(ENTITY_SITTING_TAG, humanEntity.m_21827_());
            compoundTag.m_128359_(ENTITY_AGGRESSION_LEVEL, humanEntity.getAggressionLevel().name());
            if (humanEntity.m_142480_() != null) {
                compoundTag.m_128362_(OWNER_TAG, humanEntity.m_142480_().m_142081_());
                compoundTag.m_128359_(OWNER_NAME_TAG, humanEntity.m_142480_().m_7755_().getString());
            }
            this.setArmorItems((NonNullList<ItemStack>)((NonNullList)humanEntity.m_6168_()));
            this.setHandItems((NonNullList<ItemStack>)((NonNullList)humanEntity.m_6167_()));
        } else {
            compoundTag.m_128379_(ENTITY_SITTING_TAG, this.entitySitting);
            compoundTag.m_128359_(ENTITY_AGGRESSION_LEVEL, this.entityAggressionLevel.name());
            if (this.ownerUUID != null) {
                compoundTag.m_128362_(OWNER_TAG, this.ownerUUID);
                compoundTag.m_128359_(OWNER_NAME_TAG, this.ownerName);
            }
        }
        HumanHelper.saveArmorItems(compoundTag, this.armorItems);
        HumanHelper.saveHandItems(compoundTag, this.handItems);
        HumanHelper.saveInventoryItems(compoundTag, this.inventoryItems);
        return compoundTag;
    }

    private void setDirty() {
        HumanServerData serverData = HumanServerData.get();
        if (serverData != null) {
            serverData.m_77762_();
        }
    }

    public boolean is(HumanData humanMobEntity) {
        return this.humanMobUUID == humanMobEntity.humanMobUUID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HumanData)) {
            return false;
        }
        HumanData humanMobEntity = (HumanData)object;
        return humanMobEntity.getUUID().equals(this.humanMobUUID);
    }

    public int hashCode() {
        return this.humanMobUUID.hashCode();
    }
}

