/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.ai.goal;

import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.HumanMobEntityData;
import com.craftix.hostile_humans.entity.ai.goal.HumanGoal;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class MeleeAttackGoal
extends HumanGoal {
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;

    public MeleeAttackGoal(HumanEntity humanEntity, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(humanEntity);
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean m_8036_() {
        long gameTime = this.mob.f_19853_.m_46467_();
        if (gameTime - this.lastCanUseCheck < 20L || !this.mob.shouldAttack()) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        if (!this.mob.canAttack()) {
            return false;
        }
        LivingEntity livingEntity = this.mob.m_5448_();
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!this.mob.shouldAttack() || !this.mob.canAttack()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        return this.mob.m_21444_(livingEntity.m_142538_());
    }

    public void m_8056_() {
        boolean isSit = this.mob.m_21827_();
        if (!isSit) {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        }
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        this.mob.m_6710_(null);
        this.mob.m_21561_(false);
        boolean isSit = this.mob.m_21827_();
        if (isSit) {
            this.mob.setOrderedToPosition((BlockPos)this.mob.m_20088_().m_135370_(HumanMobEntityData.DATA_SIT_POS));
        } else {
            this.mob.m_21566_().m_6849_(this.mob.m_20182_().m_7096_(), this.mob.m_20182_().m_7098_(), this.mob.m_20182_().m_7094_(), 1.0);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null) {
            Player player;
            ItemStack itemStack;
            if (livingEntity instanceof Player && ((itemStack = (player = (Player)livingEntity).m_21120_(player.m_7655_())).m_150930_(this.mob.getTameItem()) || this.mob.m_21830_((LivingEntity)player))) {
                this.m_8041_();
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double distance = this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingEntity.m_20185_();
                this.pathedTargetY = livingEntity.m_20186_();
                this.pathedTargetZ = livingEntity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                Objects.requireNonNull(this);
                if (distance > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distance > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingEntity, distance);
        }
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity, double attackDistance) {
        double distance = this.getAttackReachSqr(livingEntity);
        if (attackDistance <= distance && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            if (this.mob.m_21254_()) {
                this.mob.m_5810_();
            }
            this.mob.m_7327_((Entity)livingEntity);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected double getAttackReachSqr(LivingEntity livingEntity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + livingEntity.m_20205_();
    }
}

