/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.ai.goal;

import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.ai.goal.HumanGoal;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;

public class FoodItemGoal
extends HumanGoal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private final TargetingConditions targetingConditions;
    private final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected Player player;
    private int calmDown;
    private final Ingredient items;
    private final boolean canScare;

    public FoodItemGoal(HumanEntity humanEntity, double speedModifier) {
        super(humanEntity);
        this.speedModifier = speedModifier;
        this.items = this.mob.getFoodItems();
        this.canScare = true;
        this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return this.items.test(livingEntity.m_21205_()) || this.items.test(livingEntity.m_21206_());
    }

    @Override
    public boolean m_8036_() {
        if (!this.mob.canEat()) {
            return false;
        }
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.mob.getNearestPlayer(this.targetingConditions);
        return this.player != null;
    }

    public boolean m_8045_() {
        if (!this.mob.canEat()) {
            return false;
        }
        if (this.canScare()) {
            if (this.mob.m_20280_((Entity)this.player) < 36.0) {
                if (this.player.m_20275_(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)this.player.m_146908_() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.m_20185_();
                this.py = this.player.m_20186_();
                this.pz = this.player.m_20189_();
            }
            this.pRotX = this.player.m_146909_();
            this.pRotY = this.player.m_146908_();
        }
        return this.m_8036_();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void m_8056_() {
        this.px = this.player.m_20185_();
        this.py = this.player.m_20186_();
        this.pz = this.player.m_20189_();
    }

    public void m_8041_() {
        this.player = null;
        this.mob.m_21573_().m_26573_();
        this.calmDown = FoodItemGoal.m_186073_((int)100);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.player, (float)this.mob.m_8085_() + 20.0f, (float)this.mob.m_8132_());
        if (this.mob.m_20280_((Entity)this.player) < 6.25) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
        }
    }
}

