/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity.ai.goal;

import com.craftix.hostile_humans.entity.HumanEntity;
import com.craftix.hostile_humans.entity.HumanMobEntityData;
import com.craftix.hostile_humans.entity.ai.goal.CrossbowGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;

public class BowAttack<T extends HumanEntity>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private int updatePathDelay;

    public BowAttack(T p_25792_, double p_25793_, int interval, float p_25795_) {
        this.mob = p_25792_;
        this.speedModifier = p_25793_;
        this.attackIntervalMin = interval;
        this.attackRadiusSqr = p_25795_ * p_25795_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int p_25798_) {
        this.attackIntervalMin = p_25798_;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof BowItem);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingBow();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
        boolean isSit = this.mob.m_21827_();
        if (isSit) {
            ((HumanMobEntityData)this.mob).setOrderedToPosition((BlockPos)this.mob.m_20088_().m_135370_(HumanMobEntityData.DATA_SIT_POS));
        } else {
            this.mob.m_21566_().m_6849_(this.mob.m_20182_().m_7096_(), this.mob.m_20182_().m_7098_(), this.mob.m_20182_().m_7094_(), 1.0);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            boolean flag2;
            boolean flag1;
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.m_20280_((Entity)livingentity);
            boolean bl2 = flag2 = d0 > (double)this.attackRadiusSqr || this.seeTime < 5;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier * 0.5);
                    this.updatePathDelay = CrossbowGoal.PATHFINDING_DELAY_RANGE.m_142270_(this.mob.m_21187_());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.mob.m_6117_()) {
                ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
                this.mob.m_5810_();
                this.attackTime = this.attackIntervalMin;
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
            }
        }
    }
}

