/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.hostile_humans.entity;

import com.craftix.hostile_humans.entity.HumanCommand;
import com.craftix.hostile_humans.entity.HumanMobEntityData;
import com.craftix.hostile_humans.entity.ai.goal.FoodItemGoal;
import com.craftix.hostile_humans.entity.ai.goal.TameItemGoal;
import com.craftix.hostile_humans.entity.data.HumanData;
import com.craftix.hostile_humans.entity.data.HumanServerData;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HumanEntity
extends HumanMobEntityData {
    public static final MobCategory CATEGORY = MobCategory.CREATURE;

    public HumanEntity(EntityType<? extends HumanEntity> entityType, Level level) {
        super(entityType, level);
        this.setSyncReference(this);
        this.setDataSyncNeeded();
    }

    public Item getTameItem() {
        return null;
    }

    public Ingredient getFoodItems() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getTameItem()});
    }

    protected void pet() {
        if (this.m_21223_() < this.m_21233_()) {
            this.m_21153_((float)((double)this.m_21223_() + 0.1));
        }
    }

    public void follow() {
        this.m_21839_(false);
        this.f_21344_.m_26569_();
    }

    public boolean eat(ItemStack itemStack, Player player) {
        if (!this.canEat(itemStack)) {
            return false;
        }
        this.m_146859_(GameEvent.f_157771_, this.m_146901_());
        Item item = itemStack.m_41720_();
        this.m_5634_(item.m_41473_() != null ? (float)item.m_41473_().m_38744_() : 0.5f);
        if (item.m_41473_() != null) {
            for (Pair pair : item.m_41473_().m_38749_()) {
                if (this.f_19853_.f_46443_ || pair.getFirst() == null || !(this.f_19853_.f_46441_.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                this.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if (player != null && !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_146850_(GameEvent.f_157806_);
        return true;
    }

    public boolean canEat() {
        return this.m_21223_() < this.m_21233_();
    }

    public boolean canEat(ItemStack itemStack) {
        return this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_();
    }

    protected void sit() {
        this.m_21839_(true);
        this.f_21344_.m_26573_();
        this.f_19804_.m_135381_(DATA_SIT_POS, (Object)this.m_142538_());
        System.out.println(this.m_20088_().m_135370_(DATA_SIT_POS));
        super.m_6710_(null);
    }

    public void handleCommand(HumanCommand command) {
        switch (command) {
            case SIT: {
                this.sit();
                break;
            }
            case FOLLOW: {
                this.follow();
                break;
            }
            case SIT_FOLLOW_TOGGLE: {
                if (this.m_21827_()) {
                    this.follow();
                    break;
                }
                this.sit();
                break;
            }
            case AGGRESSION_LEVEL_TOGGLE: {
                this.toggleAggressionLevel();
                break;
            }
            case PET: {
                this.pet();
            }
        }
    }

    public void finalizeSpawn() {
        ItemStack offHandItemStack;
        ItemStack mainHandItemStack;
        if (!this.m_8077_()) {
            this.m_6593_((Component)this.getCustomHumanMobNameComponent());
        }
        if (!(mainHandItemStack = this.m_6844_(EquipmentSlot.MAINHAND)).m_41619_()) {
            this.onMainHandItemSlotChange(mainHandItemStack);
        }
        if (!(offHandItemStack = this.m_6844_(EquipmentSlot.OFFHAND)).m_41619_()) {
            this.onOffHandItemSlotChange(offHandItemStack);
        }
        this.registerData();
    }

    public void sendOwnerMessage(Component component) {
        LivingEntity owner = this.m_142480_();
        if (component != null && owner != null) {
            owner.m_6352_(component, Util.f_137441_);
        }
    }

    public int m_8100_() {
        return 400;
    }

    public float m_6121_() {
        return 1.0f;
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        if (this.m_5448_() == livingEntity) {
            return;
        }
        if (livingEntity == null || !livingEntity.m_6084_()) {
            super.m_6710_(null);
            this.setDataSyncNeeded();
            return;
        }
        super.m_6710_(livingEntity);
        this.setDataSyncNeeded();
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        if (player instanceof ServerPlayer) {
            this.registerData();
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.isTamable() && this.getTameItem() != null) {
            this.f_21345_.m_25352_(3, (Goal)new TameItemGoal(this, 0.8));
        }
        if (this.getFoodItems() != null) {
            this.f_21345_.m_25352_(3, (Goal)new FoodItemGoal(this, 1.0));
        }
    }

    @Override
    public HumanEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(player.m_7655_());
        if (this.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        if (this.canEat(itemStack) && this.eat(itemStack, player)) {
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        if (this.getFoodItems() != null) {
            return this.getFoodItems().test(itemStack);
        }
        if (!itemStack.m_41614_()) {
            return false;
        }
        return super.m_6898_(itemStack);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setDataSyncNeeded();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        this.finalizeSpawn();
        return spawnGroupData;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_5907_() {
        if (!this.f_19853_.f_46443_) {
            HumanData humanMobEntityData = HumanServerData.get().getHumanMob(this.m_142081_());
            if (humanMobEntityData == null) {
                return;
            }
            float dropChance = 0.2f;
            NonNullList<ItemStack> inventory = humanMobEntityData.getInventoryItems();
            if (inventory != null) {
                for (ItemStack itemstack : inventory) {
                    if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !(this.f_19796_.nextFloat() < dropChance)) continue;
                    this.m_19983_(itemstack);
                }
            }
            if ((inventory = humanMobEntityData.getArmorItems()) != null) {
                for (ItemStack itemstack : inventory) {
                    if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !(this.f_19796_.nextFloat() < dropChance)) continue;
                    this.m_19983_(itemstack);
                }
            }
            if ((inventory = humanMobEntityData.getHandItems()) != null) {
                for (ItemStack itemstack : inventory) {
                    if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !(this.f_19796_.nextFloat() < dropChance)) continue;
                    this.m_19983_(itemstack);
                }
            }
        }
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.m_20095_();
        this.m_21455_(true, true);
        this.m_21219_();
    }

    public void m_21839_(boolean sit) {
        if (this.m_21827_() != sit) {
            super.m_21839_(sit);
            this.setDataSyncNeeded();
        }
    }
}

