/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.common.systems;

import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.common.configuration.ConfigData;
import mirsario.cameraoverhaul.core.callbacks.CameraUpdateCallback;
import mirsario.cameraoverhaul.core.callbacks.ModifyCameraTransformCallback;
import mirsario.cameraoverhaul.core.structures.Transform;
import mirsario.cameraoverhaul.core.utils.MathUtils;
import mirsario.cameraoverhaul.core.utils.Vec2fUtils;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class CameraSystem
implements CameraUpdateCallback,
ModifyCameraTransformCallback {
    private static double prevForwardVelocityPitchOffset;
    private static double prevVerticalVelocityPitchOffset;
    private static double prevStrafingRollOffset;
    private static double prevCameraYaw;
    private static double yawDeltaRollOffset;
    private static double yawDeltaRollTargetOffset;
    private static final double lerpSpeed = 1.0;
    private static final Transform offsetTransform;

    public CameraSystem() {
        CameraUpdateCallback.EVENT.Register(this);
        ModifyCameraTransformCallback.EVENT.Register(this);
        CameraOverhaul.Logger.info("CameraOverhaul - CameraSystem is ready.");
    }

    @Override
    public void OnCameraUpdate(Camera camera, Transform cameraTransform, float deltaTime) {
        CameraSystem.offsetTransform.position = new Vec3(0.0, 0.0, 0.0);
        CameraSystem.offsetTransform.eulerRot = new Vec3(0.0, 0.0, 0.0);
        ConfigData config = CameraOverhaul.instance.config;
        if (!config.enabled) {
            return;
        }
        Vec3 velocity = camera.m_90592_().m_20184_();
        Vec2 relativeXZVelocity = Vec2fUtils.Rotate(new Vec2((float)velocity.f_82479_, (float)velocity.f_82481_), 360.0f - (float)cameraTransform.eulerRot.f_82480_);
        this.VerticalVelocityPitchOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.verticalVelocityPitchFactor);
        this.ForwardVelocityPitchOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.forwardVelocityPitchFactor);
        this.YawDeltaRollOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.yawDeltaRollFactor);
        this.StrafingRollOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.strafingRollFactor);
        prevCameraYaw = cameraTransform.eulerRot.f_82480_;
    }

    @Override
    public Transform ModifyCameraTransform(Camera camera, Transform transform) {
        return new Transform(transform.position.m_82549_(CameraSystem.offsetTransform.position), transform.eulerRot.m_82549_(CameraSystem.offsetTransform.eulerRot));
    }

    private void VerticalVelocityPitchOffset(Transform inputTransform, Transform outputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity) {
        double verticalVelocityPitchOffset = velocity.f_82480_ * 2.75;
        if (velocity.f_82480_ < 0.0) {
            verticalVelocityPitchOffset *= 2.25;
        }
        prevVerticalVelocityPitchOffset = verticalVelocityPitchOffset = MathUtils.Lerp(prevVerticalVelocityPitchOffset, verticalVelocityPitchOffset, deltaTime * 1.0);
        outputTransform.eulerRot = outputTransform.eulerRot.m_82520_(verticalVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void ForwardVelocityPitchOffset(Transform inputTransform, Transform outputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity) {
        double forwardVelocityPitchOffset = (double)relativeXZVelocity.f_82471_ * 5.0;
        prevForwardVelocityPitchOffset = forwardVelocityPitchOffset = MathUtils.Lerp(prevForwardVelocityPitchOffset, forwardVelocityPitchOffset, deltaTime * 1.0);
        outputTransform.eulerRot = outputTransform.eulerRot.m_82520_(forwardVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void YawDeltaRollOffset(Transform inputTransform, Transform outputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity) {
        double yawDelta = prevCameraYaw - inputTransform.eulerRot.f_82480_;
        if (yawDelta > 180.0) {
            yawDelta = 360.0 - yawDelta;
        } else if (yawDelta < -180.0) {
            yawDelta = -360.0 - yawDelta;
        }
        yawDeltaRollOffset = MathUtils.Lerp(yawDeltaRollOffset, yawDeltaRollTargetOffset += yawDelta * 0.07, deltaTime * 1.0 * 10.0);
        outputTransform.eulerRot = outputTransform.eulerRot.m_82520_(0.0, 0.0, yawDeltaRollOffset * (double)intensity);
        yawDeltaRollTargetOffset = MathUtils.Lerp(yawDeltaRollTargetOffset, 0.0, deltaTime * 0.35);
    }

    private void StrafingRollOffset(Transform inputTransform, Transform outputTransform, Vec3 velocity, Vec2 relativeXZVelocity, double deltaTime, float intensity) {
        double strafingRollOffset = (double)(-relativeXZVelocity.f_82470_) * 15.0;
        prevStrafingRollOffset = strafingRollOffset = MathUtils.Lerp(prevStrafingRollOffset, strafingRollOffset, deltaTime * 1.0);
        outputTransform.eulerRot = outputTransform.eulerRot.m_82520_(0.0, 0.0, strafingRollOffset * (double)intensity);
    }

    static {
        offsetTransform = new Transform();
    }
}

