/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.projectile;

import com.dainxt.weaponthrow.config.WeaponThrowConfig;
import com.dainxt.weaponthrow.events.WeaponThrowEvent;
import com.dainxt.weaponthrow.handlers.EnchantmentHandler;
import com.dainxt.weaponthrow.handlers.EntityHandler;
import harmonised.pmmo.skills.Skill;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class WeaponThrowEntity
extends AbstractArrow
implements ItemSupplier {
    private float clientSideRotation = 0.0f;
    private boolean counterClockwiseBounce = true;
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(WeaponThrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<CompoundTag> COMPOUND_STACK = SynchedEntityData.m_135353_(WeaponThrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<BlockPos> DESTROYED_BLOCK = SynchedEntityData.m_135353_(WeaponThrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> SHOULD_DESTROY = SynchedEntityData.m_135353_(WeaponThrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean dealtDamage;
    private float attackDamage;
    public int returningTicks;
    @Nullable
    private BlockState lastState;

    public WeaponThrowEntity(EntityType<? extends WeaponThrowEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public WeaponThrowEntity(Level worldIn, LivingEntity thrower, boolean canDestroy, float attackDamage, ItemStack thrownStackIn) {
        super((EntityType)EntityHandler.WEAPONTHROW.get(), thrower, worldIn);
        this.attackDamage = attackDamage;
        this.f_19804_.m_135381_(COMPOUND_STACK, (Object)thrownStackIn.m_41777_().m_41739_(new CompoundTag()));
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)WeaponThrowEntity.getReturnOrLoyaltyEnchantment(thrownStackIn)));
        this.f_19804_.m_135381_(DESTROYED_BLOCK, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135381_(SHOULD_DESTROY, (Object)canDestroy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public WeaponThrowEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)EntityHandler.WEAPONTHROW.get(), x, y, z, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COMPOUND_STACK, (Object)new CompoundTag());
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DESTROYED_BLOCK, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SHOULD_DESTROY, (Object)false);
    }

    public void setItemStack(ItemStack stack) {
        this.m_20088_().m_135381_(COMPOUND_STACK, (Object)stack.m_41739_(new CompoundTag()));
    }

    public ItemStack getItemStack() {
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)this.m_20088_().m_135370_(COMPOUND_STACK)));
    }

    public void shouldDestroy(boolean stack) {
        this.m_20088_().m_135381_(SHOULD_DESTROY, (Object)stack);
    }

    public boolean shouldDestroy() {
        return (Boolean)this.m_20088_().m_135370_(SHOULD_DESTROY);
    }

    public void setDestroyedBlock(BlockPos pos) {
        this.m_20088_().m_135381_(DESTROYED_BLOCK, (Object)pos);
    }

    public BlockPos getDestroyedBlock() {
        return (BlockPos)this.m_20088_().m_135370_(DESTROYED_BLOCK);
    }

    public void m_8119_() {
        int gravityLevel;
        if (this.f_36704_ > 4 && !this.dealtDamage) {
            this.dealtDamage = true;
        }
        if (!this.getDestroyedBlock().equals((Object)BlockPos.f_121853_) && !this.f_19853_.f_46443_) {
            this.doInteractions(() -> {
                SoundEvent event = this.f_19853_.m_8055_(this.getDestroyedBlock()).m_60827_().m_56775_();
                boolean destroyed = ((ServerPlayer)this.m_37282_()).f_8941_.m_9280_(this.getDestroyedBlock());
                if (destroyed) {
                    this.f_19853_.m_5594_(null, this.getDestroyedBlock(), event, SoundSource.AMBIENT, 10.0f, 1.0f);
                }
            });
            this.setDestroyedBlock(BlockPos.f_121853_);
        }
        int n = gravityLevel = (Boolean)WeaponThrowConfig.COMMON.gravityEnchant.get() != false ? EnchantmentHelper.m_44843_((Enchantment)EnchantmentHandler.GRAVITY, (ItemStack)this.getItemStack()) : 0;
        if (gravityLevel > 0) {
            this.m_20242_(true);
            if (this.f_19853_.m_151570_(this.m_142538_())) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
            if (Math.abs(this.m_20184_().m_7096_()) < 0.1 && Math.abs(this.m_20184_().m_7094_()) < 0.1 && ((Boolean)WeaponThrowConfig.COMMON.gravityDrop.get()).booleanValue()) {
                this.m_20242_(false);
            }
        }
        Entity entity = this.m_37282_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null) {
            int i;
            int n2 = i = (Boolean)WeaponThrowConfig.COMMON.returnEnchant.get() != false ? (int)((Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL)).byteValue() : 0;
            if (i > 0 && ModList.get().isLoaded("pmmo") && ((Boolean)WeaponThrowConfig.COMMON.enablePMMOIntegration.get()).booleanValue()) {
                int combatLevel = Skill.getLevel((String)Skill.COMBAT.name.toLowerCase(), (UUID)entity.m_142081_());
                int requiredLevel = (Integer)WeaponThrowConfig.COMMON.requiredCombatLoyalty.get();
                if (requiredLevel > combatLevel && requiredLevel > 0) {
                    if (entity instanceof Player) {
                        ((Player)entity).m_5661_((Component)new TranslatableComponent("weaponthrow.pmmo.requirementLoyalty", new Object[]{requiredLevel}), true);
                    }
                    i = 0;
                }
            }
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.getItemStack(), 0.1f);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (i > 0) {
                this.m_36790_(true);
                Vec3 Vec32 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + Vec32.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(Vec32.m_82541_().m_82490_(d0)));
                if (this.returningTicks == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.m_8119_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.getItemStack().m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity entity1;
        Entity entity = p_213868_1_.m_82443_();
        float f = this.attackDamage;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += (Boolean)WeaponThrowConfig.COMMON.throwEnchant.get() != false ? (float)EnchantmentHelper.m_44843_((Enchantment)EnchantmentHandler.THROW, (ItemStack)this.getItemStack()) * 1.0f : 0.0f;
            f += EnchantmentHelper.m_44833_((ItemStack)this.getItemStack(), (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = DamageSource.m_19361_((Entity)this, (Entity)((entity1 = this.m_37282_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                List nearEntities;
                int groundedLevel;
                int contusionLevel;
                LivingEntity livingentity1 = (LivingEntity)entity;
                int n = contusionLevel = (Boolean)WeaponThrowConfig.COMMON.conccusionEnchant.get() != false ? EnchantmentHelper.m_44843_((Enchantment)EnchantmentHandler.CONCCUSION, (ItemStack)this.getItemStack()) : 0;
                if (contusionLevel > 0) {
                    livingentity1.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40 * contusionLevel, 5));
                    livingentity1.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100 * contusionLevel, 3));
                }
                int fireTime = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.getItemStack());
                int n2 = groundedLevel = (Boolean)WeaponThrowConfig.COMMON.groundedEdgeEnchant.get() != false ? EnchantmentHelper.m_44843_((Enchantment)EnchantmentHandler.GROUNDEDEDGE, (ItemStack)this.getItemStack()) : 0;
                if (!(fireTime <= 0 && groundedLevel <= 0 || (nearEntities = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(1.0))).isEmpty())) {
                    for (LivingEntity nearEntity : nearEntities) {
                        if (nearEntity.m_21187_().nextInt(3) == 0) {
                            nearEntity.m_20254_(fireTime);
                        }
                        nearEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, groundedLevel - 1));
                    }
                }
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
                if (this.getItemStack().m_41720_() instanceof BlockItem) {
                    Block blockItem = Block.m_49814_((Item)this.getItemStack().m_41720_());
                    if (blockItem instanceof SandBlock) {
                        if (livingentity1.m_21187_().nextInt(10) == 0) {
                            livingentity1.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 3));
                        }
                    } else if (blockItem instanceof TorchBlock) {
                        if (livingentity1.m_21187_().nextInt(5) == 0) {
                            livingentity1.m_20254_(1);
                        }
                    } else if (blockItem instanceof AnvilBlock) {
                        livingentity1.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 3));
                        livingentity1.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 5));
                    }
                } else {
                    Item itemThrowed = this.getItemStack().m_41720_();
                    if (itemThrowed.equals(Items.f_42585_) || itemThrowed.equals(Items.f_42593_)) {
                        livingentity1.m_20254_(1);
                    }
                }
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundevent, 1.0f, 1.0f);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12064_;
    }

    public void m_6123_(Player entityIn) {
        Entity entity = this.m_37282_();
        if (entity == null || entity.m_142081_() == entityIn.m_142081_() || this.f_36704_ > (Integer)WeaponThrowConfig.COMMON.ticksUntilWeaponLoseOwner.get()) {
            super.m_6123_(entityIn);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.dealtDamage = compound.m_128471_("DealtDamage");
        if (compound.m_128425_("Stack", 10)) {
            this.setItemStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Stack")));
        }
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)WeaponThrowEntity.getReturnOrLoyaltyEnchantment(this.getItemStack())));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Stack", (Tag)this.m_20088_().m_135370_(COMPOUND_STACK));
        compound.m_128379_("DealtDamage", this.dealtDamage);
        if (this.lastState != null) {
            compound.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.lastState));
        }
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        if ((this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) && this.f_36704_ >= (Integer)WeaponThrowConfig.COMMON.despawnTime.get()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_6532_(HitResult result) {
        WeaponThrowEvent.OnImpact testEvent = new WeaponThrowEvent.OnImpact(this, (Player)this.m_37282_(), result);
        if (MinecraftForge.EVENT_BUS.post((Event)testEvent)) {
            return;
        }
        HitResult.Type raytraceresult$type = result.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            Entity hittedEntity = ((EntityHitResult)result).m_82443_();
            if (hittedEntity instanceof LivingEntity && this.m_37282_() instanceof Player) {
                this.doInteractions(() -> ((Player)this.m_37282_()).m_5706_(hittedEntity));
            }
            this.m_5790_((EntityHitResult)result);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockPos stickBlockPos = ((BlockHitResult)result).m_82425_();
            BlockState state = this.f_19853_.m_8055_(stickBlockPos);
            if (!WeaponThrowConfig.COMMON.blackList.get().contains(state.m_60734_()) && this.shouldDestroy()) {
                boolean canHarvest;
                boolean canBreak = (Boolean)WeaponThrowConfig.COMMON.canBreakBlocks.get();
                boolean bl = canHarvest = this.getItemStack().m_41735_(state) && canBreak;
                if (canHarvest && !this.f_19853_.f_46443_ && this.lastState == null) {
                    this.setDestroyedBlock(stickBlockPos);
                }
            }
            this.m_8060_((BlockHitResult)result);
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        this.lastState = this.f_19853_.m_8055_(p_230299_1_.m_82425_());
        Vec3 Vec32 = p_230299_1_.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(Vec32);
        Vec3 Vec31 = Vec32.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - Vec31.f_82479_, this.m_20186_() - Vec31.f_82480_, this.m_20189_() - Vec31.f_82481_);
        SoundEvent event = SoundEvents.f_12515_;
        if (this.getItemStack().m_41720_() instanceof BlockItem) {
            Block block = Block.m_49814_((Item)this.getItemStack().m_41720_());
            event = block.m_49966_().m_60827_().m_56778_();
        } else {
            event = this.lastState.m_60827_().m_56778_();
        }
        this.m_5496_(event, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36740_(event);
        this.m_36793_(false);
        this.applyBounce();
    }

    void applyBounce() {
        if (this.f_36703_ && this.getItemStack().m_41720_() instanceof BlockItem && (!(Math.abs(this.m_20184_().m_7096_()) < 0.05) || !(Math.abs(this.m_20184_().m_7094_()) < 0.05))) {
            Vec3 vec3 = this.m_20184_().m_82490_((double)0.9f);
            if (!this.f_19853_.m_8055_(this.m_20097_().m_7495_()).m_60795_() || !this.f_19853_.m_8055_(this.m_20097_().m_7494_()).m_60795_()) {
                this.m_20334_(vec3.f_82479_, -vec3.f_82480_, vec3.f_82481_);
            } else if (!this.f_19853_.m_8055_(this.m_20097_().m_142125_()).m_60795_() || !this.f_19853_.m_8055_(this.m_20097_().m_142126_()).m_60795_()) {
                this.m_20334_(-vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            } else if (!this.f_19853_.m_8055_(this.m_20097_().m_142127_()).m_60795_() || !this.f_19853_.m_8055_(this.m_20097_().m_142128_()).m_60795_()) {
                this.m_20334_(vec3.f_82479_, vec3.f_82480_, -vec3.f_82481_);
            }
            this.counterClockwiseBounce = !this.counterClockwiseBounce;
            this.f_36703_ = false;
        }
    }

    public ItemStack m_7846_() {
        return this.getItemStack();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void doInteractions(Runnable action) {
        ItemStack originalStack = ((Player)this.m_37282_()).m_21120_(InteractionHand.MAIN_HAND);
        ((Player)this.m_37282_()).m_21008_(InteractionHand.MAIN_HAND, this.getItemStack());
        action.run();
        ItemStack newStack = ((Player)this.m_37282_()).m_21120_(InteractionHand.MAIN_HAND);
        if (!newStack.m_41619_()) {
            ((Player)this.m_37282_()).m_21008_(InteractionHand.MAIN_HAND, originalStack);
        } else {
            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12018_, SoundSource.AMBIENT, 0.8f, 10.0f);
            this.spawnItemParticles(this.getItemStack(), 5);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void spawnItemParticles(ItemStack p_21061_, int p_21062_) {
        for (int i = 0; i < p_21062_; ++i) {
            Vec3 vec3 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            double d0 = (double)(-this.f_19796_.nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                continue;
            }
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    public static int getReturnOrLoyaltyEnchantment(ItemStack stack) {
        int loyaltyLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44955_, (ItemStack)stack);
        int returnLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantmentHandler.RETURN, (ItemStack)stack);
        return loyaltyLevel > 0 ? loyaltyLevel : returnLevel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotationAnimation(float partialTicks) {
        if (!this.f_36703_) {
            this.clientSideRotation = WeaponThrowConfig.COMMON.noRollList.get().contains(this.m_7846_().m_41720_()) ? (float)((double)(this.counterClockwiseBounce ? 1 : -1) * (Double)WeaponThrowConfig.COMMON.fixedRoll.get()) : (float)(this.counterClockwiseBounce ? 1 : -1) * ((float)this.f_19797_ + partialTicks) * 50.0f;
        }
        return this.clientSideRotation;
    }
}

