/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class BlockReport {
    private final Path loc;

    public BlockReport(String baseName) {
        this.loc = BlockReport.getUniqueFileName(FMLPaths.GAMEDIR.get().resolve("presencefootsteps"), baseName, ".json");
    }

    public CompletableFuture<?> execute(@Nullable Predicate<BlockState> filter) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.writeReport(filter);
                this.printResults();
            }
            catch (Exception e) {
                BlockReport.addMessage((Component)new TranslatableComponent("pf.report.error", new Object[]{e.getMessage()}).m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            }
        });
    }

    private void writeReport(@Nullable Predicate<BlockState> filter) throws IOException {
        Files.createDirectories(this.loc.getParent(), new FileAttribute[0]);
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(this.loc, new OpenOption[0]));){
            writer.setIndent("    ");
            writer.beginObject();
            writer.name("blocks");
            writer.beginObject();
            Registry.f_122824_.forEach(block -> {
                BlockState state = block.m_49966_();
                try {
                    if (filter == null || filter.test(state)) {
                        writer.name(Registry.f_122824_.m_7981_(block).toString());
                        writer.beginObject();
                        writer.name("class");
                        writer.value(this.getClassData(state));
                        writer.name("sound");
                        writer.value(this.getSoundData(state));
                        writer.name("association");
                        writer.value(PresenceFootsteps.getInstance().getEngine().getIsolator().getBlockMap().getAssociation(state, ""));
                        writer.endObject();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.endObject();
            writer.name("unmapped_entities");
            writer.beginArray();
            Registry.f_122826_.forEach(type -> {
                if (type.m_20615_((Level)Minecraft.m_91087_().f_91073_) instanceof LivingEntity) {
                    ResourceLocation id = Registry.f_122826_.m_7981_(type);
                    if (!PresenceFootsteps.getInstance().getEngine().getIsolator().getLocomotionMap().contains(id)) {
                        try {
                            writer.value(id.toString());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            writer.endArray();
            writer.endObject();
        }
    }

    private String getSoundData(BlockState state) {
        if (state.m_60827_() == null) {
            return "NULL";
        }
        if (state.m_60827_().m_56776_() == null) {
            return "NO_SOUND";
        }
        return state.m_60827_().m_56776_().m_11660_().m_135815_();
    }

    private String getClassData(BlockState state) {
        Block block = state.m_60734_();
        Object soundName = "";
        if (block instanceof BasePressurePlateBlock) {
            soundName = (String)soundName + ",EXTENDS_PRESSURE_PLATE";
        }
        if (block instanceof BaseRailBlock) {
            soundName = (String)soundName + ",EXTENDS_RAIL";
        }
        if (block instanceof BaseEntityBlock) {
            soundName = (String)soundName + ",EXTENDS_CONTAINER";
        }
        if (block instanceof LiquidBlock) {
            soundName = (String)soundName + ",EXTENDS_LIQUID";
        }
        if (block instanceof BushBlock) {
            soundName = (String)soundName + ",EXTENDS_PLANT";
        }
        if (block instanceof DoublePlantBlock) {
            soundName = (String)soundName + ",EXTENDS_DOUBLE_PLANT";
        }
        if (block instanceof PipeBlock) {
            soundName = (String)soundName + ",EXTENDS_CONNECTED_PLANT";
        }
        if (block instanceof LeavesBlock) {
            soundName = (String)soundName + ",EXTENDS_LEAVES";
        }
        if (block instanceof SlabBlock) {
            soundName = (String)soundName + ",EXTENDS_SLAB";
        }
        if (block instanceof StairBlock) {
            soundName = (String)soundName + ",EXTENDS_STAIRS";
        }
        if (block instanceof SnowyDirtBlock) {
            soundName = (String)soundName + ",EXTENDS_SNOWY";
        }
        if (block instanceof SpreadingSnowyDirtBlock) {
            soundName = (String)soundName + ",EXTENDS_SPREADABLE";
        }
        if (block instanceof FallingBlock) {
            soundName = (String)soundName + ",EXTENDS_PHYSICALLY_FALLING";
        }
        if (block instanceof IronBarsBlock) {
            soundName = (String)soundName + ",EXTENDS_PANE";
        }
        if (block instanceof HorizontalDirectionalBlock) {
            soundName = (String)soundName + ",EXTENDS_PILLAR";
        }
        if (block instanceof TorchBlock) {
            soundName = (String)soundName + ",EXTENDS_TORCH";
        }
        if (block instanceof CarpetBlock) {
            soundName = (String)soundName + ",EXTENDS_CARPET";
        }
        if (block instanceof InfestedBlock) {
            soundName = (String)soundName + ",EXTENDS_INFESTED";
        }
        if (block instanceof HalfTransparentBlock) {
            soundName = (String)soundName + ",EXTENDS_TRANSPARENT";
        }
        return soundName;
    }

    private void printResults() {
        BlockReport.addMessage((Component)new TranslatableComponent("pf.report.save").m_7220_((Component)new TextComponent(this.loc.getFileName().toString()).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.loc.toString())).m_131157_(ChatFormatting.UNDERLINE))).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN)));
    }

    public static void addMessage(Component text) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(text);
    }

    static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (String)(counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }
}

