/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.player;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.player.DelayedSoundPlayer;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.sound.player.StepSoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class ImmediateSoundPlayer
implements SoundPlayer,
StepSoundPlayer {
    private final Random random = new Random();
    private final DelayedSoundPlayer delayedPlayer = new DelayedSoundPlayer(this);
    private final SoundEngine engine;

    public ImmediateSoundPlayer(SoundEngine engine) {
        this.engine = engine;
    }

    @Override
    public Random getRNG() {
        return this.random;
    }

    @Override
    public void playStep(Association assos) {
        SoundType soundType = assos.getSoundGroup();
        if (!assos.getMaterial().m_76332_() && soundType != null) {
            BlockState beside = assos.getSource().f_19853_.m_8055_(assos.getPos().m_7494_());
            if (beside.m_60734_() == Blocks.f_50125_) {
                soundType = Blocks.f_50125_.m_49962_(beside);
            }
            this.playAttenuatedSound(assos.getSource(), soundType.m_56776_().m_11660_().toString(), soundType.m_56773_() * 0.15f, soundType.m_56774_());
        }
    }

    @Override
    public void playSound(LivingEntity location, String soundName, float volume, float pitch, Options options) {
        if (options.containsKey("delay_min") && options.containsKey("delay_max")) {
            this.delayedPlayer.playSound(location, soundName, volume, pitch, options);
            return;
        }
        this.playAttenuatedSound(location, soundName, volume, pitch);
    }

    private void playAttenuatedSound(LivingEntity location, String soundName, float volume, float pitch) {
        Minecraft mc = Minecraft.m_91087_();
        double distance = mc.f_91063_.m_109153_().m_90583_().m_82557_(location.m_20182_());
        UncappedSoundInstance sound = new UncappedSoundInstance(soundName, volume *= this.engine.getVolumeForSource(location), pitch, (Entity)location);
        if (distance > 100.0) {
            mc.m_91106_().m_120369_((SoundInstance)sound, (int)Math.floor(Math.sqrt(distance) / 2.0));
        } else {
            mc.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    @Override
    public void think() {
        this.delayedPlayer.think();
    }

    public static class UncappedSoundInstance
    extends SimpleSoundInstance {
        public UncappedSoundInstance(String soundName, float volume, float pitch, Entity entity) {
            super(UncappedSoundInstance.getSoundId(soundName, entity), entity.m_5720_(), volume, pitch, false, 0, SoundInstance.Attenuation.NONE, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), false);
        }

        public float getMaxVolume() {
            return 3.0f;
        }

        private static ResourceLocation getSoundId(String name, Entity location) {
            if (name.indexOf(58) >= 0) {
                return new ResourceLocation(name);
            }
            Object domain = "presencefootsteps";
            if (!PlayerUtil.isClientPlayer(location)) {
                domain = (String)domain + "mono";
            }
            return new ResourceLocation((String)domain, name);
        }
    }
}

