/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.mixins.ILivingEntity;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.MotionTracker;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.Solver;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

class TerrestrialStepSoundGenerator
implements StepSoundGenerator {
    protected Solver solver;
    protected AcousticLibrary acoustics;
    protected Variator variator;
    protected final MotionTracker motionTracker = new MotionTracker(this);
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected boolean isAirborne;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected long immobilePlayback;
    protected int immobileInterval;
    protected boolean isRightFoot;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    private boolean stepThisFrame;
    private boolean isMessyFoliage;
    private long brushesTime;
    private final Modifier<TerrestrialStepSoundGenerator> modifier;

    public TerrestrialStepSoundGenerator(Modifier<TerrestrialStepSoundGenerator> modifier) {
        this.modifier = modifier;
    }

    @Override
    public void setIsolator(Isolator isolator) {
        this.solver = isolator.getSolver();
        this.acoustics = isolator.getAcoustics();
        this.variator = isolator.getVariator();
    }

    @Override
    public MotionTracker getMotionTracker() {
        return this.motionTracker;
    }

    @Override
    public boolean generateFootsteps(LivingEntity ply) {
        this.motionTracker.simulateMotionData(ply);
        this.simulateFootsteps(ply);
        this.simulateAirborne(ply);
        this.simulateBrushes(ply);
        this.simulateStationary(ply);
        return true;
    }

    protected void simulateStationary(LivingEntity ply) {
        Association assos;
        if (this.isImmobile && (ply.m_20096_() || !ply.m_5842_()) && this.playbackImmobile() && ((assos = this.solver.findAssociation(ply, 0.0, this.isRightFoot)).hasAssociation() || !this.isImmobile)) {
            this.solver.playAssociation(ply, assos, State.STAND);
        }
    }

    protected boolean playbackImmobile() {
        long now = System.currentTimeMillis();
        if (now - this.immobilePlayback > (long)this.immobileInterval) {
            this.immobilePlayback = now;
            this.immobileInterval = (int)Math.floor(Math.random() * (double)(this.variator.IMOBILE_INTERVAL_MAX - this.variator.IMOBILE_INTERVAL_MIN) + (double)this.variator.IMOBILE_INTERVAL_MIN);
            return true;
        }
        return false;
    }

    protected boolean updateImmobileState(LivingEntity ply, float reference) {
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = System.currentTimeMillis();
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return System.currentTimeMillis() - this.timeImmobile > (long)this.variator.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void simulateFootsteps(LivingEntity ply) {
        double movZ;
        double movX;
        double scal;
        float distanceReference = ply.f_19788_;
        this.stepThisFrame = false;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = this.motionTracker.getMotionX()) * this.xMovec + (movZ = this.motionTracker.getMotionZ()) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.variator.PLAY_WANDER && !this.hasStoppingConditions((Entity)ply)) {
                this.solver.playAssociation(ply, this.solver.findAssociation(ply, 0.0, this.isRightFoot), State.WANDER);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        float dwm = distanceReference - this.dmwBase;
        boolean immobile = this.updateImmobileState(ply, distanceReference);
        if (immobile && !ply.m_6147_()) {
            dwm = 0.0f;
            this.dmwBase = distanceReference;
        }
        if (ply.m_20096_() || ply.m_5842_() || ply.m_6147_()) {
            State event = null;
            float distance = 0.0f;
            double verticalOffsetAsMinus = 0.0;
            if (ply.m_6147_() && !ply.m_20096_()) {
                distance = this.variator.DISTANCE_LADDER;
            } else if (!ply.m_5842_() && Math.abs(this.yPosition - ply.m_20186_()) > 0.4) {
                if (this.yPosition < ply.m_20186_()) {
                    distance = this.variator.DISTANCE_STAIR;
                    event = this.motionTracker.pickState(ply, State.UP, State.UP_RUN);
                } else if (!ply.m_6144_()) {
                    distance = -1.0f;
                    verticalOffsetAsMinus = 0.0;
                    event = this.motionTracker.pickState(ply, State.DOWN, State.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.variator.DISTANCE_HUMAN;
            }
            if (event == null) {
                event = this.motionTracker.pickState(ply, State.WALK, State.RUN);
            }
            if (dwm > (distance = this.modifier.reevaluateDistance(event, distance))) {
                this.produceStep(ply, event, verticalOffsetAsMinus);
                this.modifier.stepped(this, ply, event);
                this.dmwBase = distanceReference;
            }
        }
        if (ply.m_20096_()) {
            this.yPosition = ply.m_20186_();
        }
    }

    public final void produceStep(LivingEntity ply, @Nullable State event) {
        this.produceStep(ply, event, 0.0);
    }

    public final void produceStep(LivingEntity ply, @Nullable State event, double verticalOffsetAsMinus) {
        if (event == null) {
            event = this.motionTracker.pickState(ply, State.WALK, State.RUN);
        }
        if (this.hasStoppingConditions((Entity)ply)) {
            float volume = Math.min(1.0f, (float)ply.m_20184_().m_82553_() * 0.35f);
            Options options = Options.singular("gliding_volume", Float.valueOf(volume));
            State state = ply.m_5842_() ? State.SWIM : event;
            this.acoustics.playAcoustic(ply, "_SWIM", state, options);
            this.solver.playAssociation(ply, this.solver.findAssociation(ply.f_19853_, ply.m_142538_().m_7495_(), "find_messy_foliage"), event);
        } else {
            this.solver.playAssociation(ply, this.solver.findAssociation(ply, verticalOffsetAsMinus, this.isRightFoot), event);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected boolean hasStoppingConditions(Entity ply) {
        return ply.m_5842_();
    }

    protected void simulateAirborne(LivingEntity ply) {
        if ((ply.m_20096_() || ply.m_6147_()) == this.isAirborne) {
            this.isAirborne = !this.isAirborne;
            this.simulateJumpingLanding(ply);
        }
    }

    protected boolean isJumping(LivingEntity ply) {
        return ((ILivingEntity)ply).isJumping();
    }

    protected double getOffsetMinus(LivingEntity ply) {
        if (ply instanceof RemotePlayer) {
            return 1.0;
        }
        return 0.0;
    }

    protected void simulateJumpingLanding(LivingEntity ply) {
        if (this.hasStoppingConditions((Entity)ply)) {
            return;
        }
        if (this.isAirborne && this.isJumping(ply)) {
            this.simulateJumping(ply);
        } else if (!this.isAirborne) {
            this.simulateLanding(ply);
        }
    }

    protected void simulateJumping(LivingEntity ply) {
        if (this.variator.EVENT_ON_JUMP) {
            if (this.motionTracker.getHorizontalSpeed() < (double)this.variator.SPEED_TO_JUMP_AS_MULTIFOOT) {
                this.playMultifoot(ply, this.getOffsetMinus(ply) + 0.4, State.WANDER);
            } else {
                this.playSinglefoot(ply, this.getOffsetMinus(ply) + 0.4, State.JUMP, this.isRightFoot);
            }
        }
    }

    protected void simulateLanding(LivingEntity ply) {
        if (ply.f_19789_ > this.variator.LAND_HARD_DISTANCE_MIN) {
            this.playMultifoot(ply, this.getOffsetMinus(ply), State.LAND);
        } else if (!ply.m_6144_()) {
            this.playSinglefoot(ply, this.getOffsetMinus(ply), this.motionTracker.pickState(ply, State.CLIMB, State.CLIMB_RUN), this.isRightFoot);
            if (!this.stepThisFrame) {
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    private void simulateBrushes(LivingEntity ply) {
        if (this.brushesTime > System.currentTimeMillis()) {
            return;
        }
        this.brushesTime = System.currentTimeMillis() + 100L;
        if (this.motionTracker.isStationary() || ply.m_6144_()) {
            return;
        }
        Association assos = this.solver.findAssociation(ply.f_19853_, new BlockPos(ply.m_20185_(), ply.m_20186_() - 0.1 - ply.m_6049_() - (ply.m_20096_() ? 0.0 : 0.25), ply.m_20189_()), "find_messy_foliage");
        if (!assos.isNull()) {
            if (!this.isMessyFoliage) {
                this.isMessyFoliage = true;
                this.solver.playAssociation(ply, assos, State.WALK);
            }
        } else if (this.isMessyFoliage) {
            this.isMessyFoliage = false;
        }
    }

    protected void playSinglefoot(LivingEntity ply, double verticalOffsetAsMinus, State eventType, boolean foot) {
        Association assos = this.solver.findAssociation(ply, verticalOffsetAsMinus, this.isRightFoot);
        if (assos.isNotEmitter()) {
            assos = this.solver.findAssociation(ply, verticalOffsetAsMinus + 1.0, this.isRightFoot);
        }
        this.solver.playAssociation(ply, assos, eventType);
    }

    protected void playMultifoot(LivingEntity ply, double verticalOffsetAsMinus, State eventType) {
        Association rightFoot;
        Association leftFoot = this.solver.findAssociation(ply, verticalOffsetAsMinus, false);
        if (leftFoot.dataEquals(rightFoot = this.solver.findAssociation(ply, verticalOffsetAsMinus, true))) {
            if (this.isRightFoot) {
                leftFoot = Association.NOT_EMITTER;
            } else {
                rightFoot = Association.NOT_EMITTER;
            }
        }
        this.solver.playAssociation(ply, leftFoot, eventType);
        this.solver.playAssociation(ply, rightFoot, eventType);
    }
}

