/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.QuadrupedModifier;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.WingedStepSoundGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public enum Locomotion {
    NONE,
    BIPED(() -> new TerrestrialStepSoundGenerator(new Modifier<TerrestrialStepSoundGenerator>())),
    QUADRUPED(() -> new TerrestrialStepSoundGenerator(new QuadrupedModifier())),
    FLYING(() -> new WingedStepSoundGenerator(new QuadrupedModifier())),
    FLYING_BIPED(() -> new WingedStepSoundGenerator(new Modifier<TerrestrialStepSoundGenerator>()));

    private static final Map<String, Locomotion> registry;
    private final Supplier<Optional<StepSoundGenerator>> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase();

    private Locomotion() {
        this.constructor = Optional::empty;
    }

    private Locomotion(Supplier<StepSoundGenerator> gen) {
        this.constructor = () -> Optional.of((StepSoundGenerator)gen.get());
    }

    public Optional<StepSoundGenerator> supplyGenerator() {
        return this.constructor.get();
    }

    public Component getOptionName() {
        return new TranslatableComponent("menu.pf.stance", new Object[]{new TranslatableComponent(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey)});
    }

    public Component getOptionTooltip() {
        return new TranslatableComponent(this.translationKey + ".tooltip");
    }

    public String getDisplayName() {
        return I18n.m_118938_((String)"pf.stance", (Object[])new Object[]{I18n.m_118938_((String)this.translationKey, (Object[])new Object[0])});
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(Entity entity, Locomotion fallback) {
        return fallback;
    }

    public static Locomotion forPlayer(Player ply, Locomotion preference) {
        if (preference == NONE) {
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new HashMap<String, Locomotion>();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

