/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.ITooltipped;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.style.IStyled;
import com.minelittlepony.common.client.gui.style.Style;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class Button
extends AbstractButton
implements ITooltipped<Button>,
IBounded,
ITextContext,
IStyled<Button> {
    private Style style = new Style();
    private final Bounds bounds;
    private static final Consumer<Button> NONE = v -> {};
    @NotNull
    private Consumer<Button> action = NONE;

    public Button(int x, int y) {
        this(x, y, 200, 20);
    }

    public Button(int x, int y, int width, int height) {
        super(x, y, width, height, TextComponent.f_131282_);
        this.bounds = new Bounds(y, x, width, height);
    }

    public Button onClick(@NotNull Consumer<? extends Button> callback) {
        this.action = callback;
        return this;
    }

    public Button setEnabled(boolean enable) {
        this.f_93623_ = enable;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Button setStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds.copy(bounds);
        this.f_93620_ = bounds.left;
        this.f_93621_ = bounds.top;
        this.f_93618_ = bounds.width;
        this.f_93619_ = bounds.height;
    }

    public void m_142291_(NarrationElementOutput narrationMsg) {
        this.m_168802_(narrationMsg);
        this.getStyle().getTooltip().ifPresent(tooltip -> tooltip.appendNarrations(narrationMsg));
    }

    public void m_5691_() {
        this.action.accept(this);
    }

    @Override
    public void renderToolTip(PoseStack matrices, Screen parent, int mouseX, int mouseY) {
        if (this.f_93624_) {
            this.getStyle().getTooltip().ifPresent(tooltip -> parent.m_96597_(matrices, tooltip.getLines(), mouseX + this.getStyle().toolTipX, mouseY + this.getStyle().toolTipY));
        }
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int state = 46 + this.m_7202_(this.m_198029_()) * 20;
        this.renderButtonBlit(matrices, this.f_93620_, this.f_93621_, state, this.f_93618_, this.f_93619_);
        this.m_7906_(matrices, mc, mouseX, mouseY);
        int foreColor = this.getStyle().getColor();
        if (!this.f_93623_) {
            foreColor = 0xA0A0A0;
        } else if (this.m_198029_()) {
            foreColor = 0xFFFFA0;
        }
        if (this.getStyle().hasIcon()) {
            this.getStyle().getIcon().render(matrices, this.f_93620_, this.f_93621_, mouseX, mouseY, partialTicks);
        }
        this.m_93666_(this.getStyle().getText());
        this.renderForground(matrices, mc, mouseX, mouseY, foreColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    protected void renderForground(PoseStack matrices, Minecraft mc, int mouseX, int mouseY, int foreColor) {
        this.drawCenteredLabel(matrices, this.m_6035_(), this.f_93620_ + this.f_93618_ / 2, this.f_93621_ + (this.f_93619_ - 8) / 2, foreColor, 0.0);
    }

    protected final void renderButtonBlit(PoseStack matrices, int x, int y, int state, int blockWidth, int blockHeight) {
        int endV = 200 - blockWidth / 2;
        int endU = state + 20 - blockHeight / 2;
        this.m_93228_(matrices, x, y, 0, state, blockWidth / 2, blockHeight / 2);
        this.m_93228_(matrices, x + blockWidth / 2, y, endV, state, blockWidth / 2, blockHeight / 2);
        this.m_93228_(matrices, x, y + blockHeight / 2, 0, endU, blockWidth / 2, blockHeight / 2);
        this.m_93228_(matrices, x + blockWidth / 2, y + blockHeight / 2, endV, endU, blockWidth / 2, blockHeight / 2);
    }
}

