/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.dimension;

import com.minelittlepony.common.client.gui.dimension.Padding;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;

public class Bounds {
    public int top;
    public int left;
    public int width;
    public int height;

    public static Bounds empty() {
        return new Bounds(0, 0, 0, 0);
    }

    public Bounds(int top, int left, int width, int height) {
        this.top = top;
        this.left = left;
        this.width = width;
        this.height = height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean contains(double x, double y) {
        return !this.isEmpty() && x >= (double)this.left && x <= (double)(this.left + this.width) && y >= (double)this.top && y <= (double)(this.top + this.height);
    }

    public Bounds add(Padding other) {
        return new Bounds(this.top - other.top, this.left - other.left, this.width + other.left + other.right, this.height + other.top + other.bottom);
    }

    public Bounds offset(Padding other) {
        return new Bounds(this.top + other.top, this.left + other.left, this.width, this.height);
    }

    public Bounds add(Bounds other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        int t = Math.min(this.top, other.top);
        int l = Math.min(this.left, other.left);
        int b = Math.max(this.top + this.height, other.top + other.height);
        int r = Math.max(this.left + this.width, other.left + other.width);
        int h = b - t;
        int w = r - l;
        return new Bounds(t, l, w, h);
    }

    public void copy(Bounds other) {
        this.top = other.top;
        this.left = other.left;
        this.width = other.width;
        this.height = other.height;
    }

    public void draw(PoseStack matrices, int tint) {
        GuiComponent.m_93172_((PoseStack)matrices, (int)this.left, (int)this.top, (int)(this.left + this.width), (int)(this.top + this.height), (int)tint);
    }

    public void debugMeasure(PoseStack matrices) {
        Window window = Minecraft.m_91087_().m_91268_();
        GuiComponent.m_93172_((PoseStack)matrices, (int)this.left, (int)0, (int)(this.left + 1), (int)window.m_85446_(), (int)-1);
        GuiComponent.m_93172_((PoseStack)matrices, (int)(this.left + this.width), (int)0, (int)(this.left + this.width + 1), (int)window.m_85446_(), (int)-1);
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)this.top, (int)window.m_85445_(), (int)(this.top + 1), (int)-1);
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)(this.top + this.height), (int)window.m_85445_(), (int)(this.top + this.height + 1), (int)-1);
    }

    protected boolean equals(Bounds o) {
        return this == o || o.top == this.top && o.left == this.left && o.width == this.width && o.height == this.height;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Bounds && this.equals((Bounds)o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.width;
        return result;
    }
}

