/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.util;

import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import com.natamus.collective_common_fabric.functions.PlayerFunctions;
import com.natamus.starterkit_common_fabric.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class Util {
    public static String startergearstring = "";
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "starterkit";

    public static void getOrCreateGearConfig(boolean first) throws IOException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            String configstring = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "starterkit.txt", new String[0])));
            if (configstring.startsWith("'")) {
                startergearstring = configstring;
            } else {
                HashMap<String, class_1799> simplegear = new HashMap<String, class_1799>();
                for (String line : configstring.split(",")) {
                    class_1792 item;
                    String[] itemspl;
                    String[] linespl = line.replace(" ", "").trim().split(":\"");
                    if (linespl.length < 2) continue;
                    int amount = 1;
                    String slotstring = linespl[0].replace("\"", "").trim();
                    String itemstring = linespl[1].replace("\"", "").trim();
                    if (itemstring.contains("-") && (itemspl = itemstring.split("-")).length > 1) {
                        itemstring = itemspl[0];
                        if (NumberFunctions.isNumeric((String)itemspl[1])) {
                            amount = Integer.parseInt(itemspl[1]);
                        }
                    }
                    class_2960 itemloc = new class_2960(itemstring);
                    if (class_2378.field_11142.method_10235().contains(itemloc)) {
                        item = (class_1792)class_2378.field_11142.method_10223(itemloc);
                    } else {
                        if (!class_2378.field_11146.method_10235().contains(itemloc)) continue;
                        class_2248 block = (class_2248)class_2378.field_11146.method_10223(itemloc);
                        item = block.method_8389();
                    }
                    simplegear.put(slotstring, new class_1799((class_1935)item, amount));
                }
                startergearstring = PlayerFunctions.getPlayerGearStringFromHashMap(simplegear);
            }
        } else {
            dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", StandardCharsets.UTF_8);
            writer.println("'offhand' : '{Count:1b,id:\"minecraft:shield\",tag:{Damage:0}}',");
            writer.println("'head' : '',");
            writer.println("'chest' : '',");
            writer.println("'legs' : '',");
            writer.println("'feet' : '{Count:1b,id:\"minecraft:leather_boots\",tag:{Damage:0}}',");
            class_2371 emptyinventory = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
            for (int i = 0; i < emptyinventory.size(); ++i) {
                String itemstring = "";
                if (i == 0) {
                    itemstring = "{Count:1b,id:\"minecraft:wooden_sword\",tag:{Damage:0}}";
                } else if (i == 1) {
                    itemstring = "{Count:9b,id:\"minecraft:bread\"}";
                }
                writer.println(i + " : '" + itemstring + "',");
            }
            writer.close();
            if (first) {
                Util.getOrCreateGearConfig(false);
            }
        }
    }

    public static boolean createGearConfigFromGearString(String gearstring) throws IOException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            File renamedfile = new File(dirpath + File.separator + "starterkit-old.txt");
            int r = 0;
            while (renamedfile.exists()) {
                renamedfile = new File(dirpath + File.separator + "starterkit-old_" + r + ".txt");
                ++r;
            }
            file.renameTo(renamedfile);
        } else {
            dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", StandardCharsets.UTF_8);
        writer.println(gearstring);
        writer.close();
        Util.getOrCreateGearConfig(false);
        return true;
    }

    public static void setStarterKit(class_1657 player) {
        if (startergearstring.equals("")) {
            return;
        }
        ArrayList<class_1799> toAddAfter = new ArrayList<class_1799>();
        if (ConfigHandler.addExistingItemsAfterKitSet) {
            class_1661 inv = player.method_31548();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                class_1799 itemStack = inv.method_5438(i);
                if (itemStack.method_7960()) continue;
                toAddAfter.add(itemStack.method_7972());
            }
        }
        PlayerFunctions.setPlayerGearFromString((class_1657)player, (String)startergearstring);
        if (toAddAfter.size() > 0) {
            for (class_1799 itemStackToAdd : toAddAfter) {
                ItemFunctions.giveOrDropItemStack((class_1657)player, (class_1799)itemStackToAdd);
            }
        }
    }

    public static boolean processNewGearString(String gearstring) {
        try {
            if (Util.createGearConfigFromGearString(gearstring)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

