/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.teamremastered.endrem.EndRemastered;
import com.teamremastered.endrem.config.ERConfigGenericEntry;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ERConfig {
    private static final ForgeConfigSpec.Builder CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ERConfigGenericEntry<Boolean> USE_ENDER_EYES_ENABLED;
    public static ERConfigGenericEntry<Integer> EYE_BREAK_CHANCE;
    public static ERConfigGenericEntry<Boolean> CAN_REMOVE_EYE;
    public static ERConfigGenericEntry<Boolean> IS_CRYPTIC_EYE_OBTAINABLE;
    public static ERConfigGenericEntry<Boolean> IS_EVIL_EYE_OBTAINABLE;

    private static void init() {
        CONFIG.push("endrem");
        for (ERConfigGenericEntry<?> ccv : ERConfigGenericEntry.erConfigGenericEntries) {
            ccv.setup(CONFIG);
        }
        CONFIG.pop();
        COMMON_CONFIG = CONFIG.build();
    }

    public static void load() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve(EndRemastered.CONFIG_FILE)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    static {
        USE_ENDER_EYES_ENABLED = new ERConfigGenericEntry<Boolean>("ender_eyes", "Toggle Ender Eyes Actions (Throwing and Placing in Portal Frames)", false);
        EYE_BREAK_CHANCE = new ERConfigGenericEntry<Integer>("eye_break_chance", "Percentage chance of eyes breaking when thrown", 10);
        CAN_REMOVE_EYE = new ERConfigGenericEntry<Boolean>("can_remove_eye", "Decides whether or not you can remove an ender eye from a frame", false);
        IS_CRYPTIC_EYE_OBTAINABLE = new ERConfigGenericEntry<Boolean>("is_cryptic_eye_obtainable", "Decides if it's possible to obtain the cryptic eye when enchanting", true);
        IS_EVIL_EYE_OBTAINABLE = new ERConfigGenericEntry<Boolean>("is_evil_eye_obtainable", "Decides if it's possible to obtain the evil eye when trading with a Cleric", true);
        ERConfig.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG, EndRemastered.CONFIG_FILE);
    }
}

