/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import net.combatroll.CombatRoll;
import net.combatroll.Platform;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.client.MinecraftClientExtension;
import net.combatroll.client.RollEffect;
import net.combatroll.client.RollKeybings;
import net.combatroll.client.RollManager;
import net.combatroll.compatibility.BetterCombatHelper;
import net.combatroll.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.combatroll.network.Packets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class}, priority=449)
public abstract class MinecraftClientMixin
implements MinecraftClientExtension {
    @Shadow
    private int f_91011_;
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    private RollManager rollManager = new RollManager();

    @Override
    public RollManager getRollManager() {
        return this.rollManager;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(Screen screen, CallbackInfo ci) {
        this.rollManager.isEnabled = false;
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD(CallbackInfoReturnable<Boolean> info) {
        if (this.rollManager.isRolling()) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBlockBreaking_HEAD(boolean bl, CallbackInfo ci) {
        if (this.rollManager.isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD(CallbackInfo ci) {
        if (this.rollManager.isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL(CallbackInfo ci) {
        this.tryRolling();
    }

    private void tryRolling() {
        Minecraft client = (Minecraft)this;
        if (this.f_91074_ == null || client.m_91104_()) {
            return;
        }
        this.rollManager.tick(this.f_91074_);
        if (RollKeybings.roll.m_90857_()) {
            float defaultSlipperiness;
            if (Platform.Forge && client.f_91080_ != null) {
                return;
            }
            if (!this.rollManager.isRollAvailable((Player)this.f_91074_)) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_airborn && !this.f_91074_.m_20096_()) {
                return;
            }
            if (this.f_91074_.m_6069_()) {
                return;
            }
            if (this.f_91074_.m_20202_() != null) {
                return;
            }
            if (this.f_91074_.m_6117_() || this.f_91074_.m_21254_()) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_weapon_cooldown && (double)this.f_91074_.m_36403_(0.0f) < 0.95) {
                return;
            }
            if (BetterCombatHelper.isDoingUpswing()) {
                BetterCombatHelper.cancelUpswing();
            } else if (client.f_91066_.f_92096_.m_90857_()) {
                return;
            }
            if (this.f_91011_ > 0) {
                return;
            }
            float forward = this.f_91074_.f_108618_.f_108567_;
            float sideways = this.f_91074_.f_108618_.f_108566_;
            Vec3 direction = forward == 0.0f && sideways == 0.0f ? new Vec3(0.0, 0.0, 1.0) : new Vec3((double)sideways, 0.0, (double)forward).m_82541_();
            direction = direction.m_82524_((float)Math.toRadians(-1.0 * (double)this.f_91074_.m_146908_()));
            double distance = 0.475 * (EntityAttributes_CombatRoll.getAttributeValue((Player)this.f_91074_, EntityAttributes_CombatRoll.Type.DISTANCE) + (double)CombatRoll.config.additional_roll_distance);
            direction = direction.m_82490_(distance);
            Block block = this.f_91074_.f_19853_.m_8055_(this.f_91074_.m_142538_().m_7495_()).m_60734_();
            float slipperiness = block.m_49958_();
            if (slipperiness > (defaultSlipperiness = Blocks.f_50034_.m_49958_())) {
                float multiplier = defaultSlipperiness / slipperiness;
                direction = direction.m_82490_((double)(multiplier * multiplier));
            }
            this.f_91074_.m_5997_(direction.f_82479_, direction.f_82480_, direction.f_82481_);
            this.rollManager.onRoll(this.f_91074_);
            RollEffect.Visuals rollVisuals = new RollEffect.Visuals("combatroll:roll", RollEffect.Particles.PUFF);
            ClientPlayNetworking.send(Packets.RollPublish.ID, new Packets.RollPublish(this.f_91074_.m_142049_(), rollVisuals, direction).write());
            RollEffect.playVisuals(rollVisuals, (Player)this.f_91074_, direction);
        }
    }
}

