/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.forge;

import net.combatroll.CombatRoll;
import net.combatroll.fabricmc.fabric.api.networking.v1.NetworkHandler;
import net.combatroll.utils.SoundHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="combatroll")
public class ForgeMod {
    public static DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"combatroll");

    public ForgeMod() {
        CombatRoll.init();
        NetworkHandler.registerMessages();
        this.registerSounds();
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CombatRoll.configureEnchantments();
    }

    @SubscribeEvent
    public void registerAttributes(RegistryEvent.Register<Attribute> event) {
        CombatRoll.registerAttributes();
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        CombatRoll.configureEnchantments();
        CombatRoll.registerEnchantments();
    }

    private void registerSounds() {
        for (String soundKey : SoundHelper.soundKeys) {
            SOUNDS.register(soundKey, () -> new SoundEvent(new ResourceLocation("combatroll", soundKey)));
        }
    }
}

