/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.combatroll.client.CombatRollClient;
import net.combatroll.client.MinecraftClientExtension;
import net.combatroll.client.RollManager;
import net.combatroll.client.gui.HudElement;
import net.combatroll.config.ClientConfig;
import net.combatroll.config.HudConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class HudRenderHelper {
    private static final ResourceLocation ARROW = new ResourceLocation("combatroll", "textures/hud/arrow.png");
    private static final ResourceLocation ARROW_BACKGROUND = new ResourceLocation("combatroll", "textures/hud/arrow_background.png");

    public static void render(PoseStack matrixStack, float tickDelta) {
        ViewModel viewModel;
        ClientConfig config = CombatRollClient.config;
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            viewModel = ViewModel.mock();
        } else {
            if (player.m_7500_() && !config.showHUDInCreative) {
                return;
            }
            if (player.m_5833_()) {
                return;
            }
            RollManager.CooldownInfo cooldownInfo = ((MinecraftClientExtension)client).getRollManager().getCooldown();
            if (!config.showWhenFull && cooldownInfo.availableRolls() == cooldownInfo.maxRolls()) {
                return;
            }
            viewModel = ViewModel.create(cooldownInfo, tickDelta);
        }
        int screenWidth = client.m_91268_().m_85445_();
        int screenHeight = client.m_91268_().m_85446_();
        HudElement rollWidget = ((HudConfig)CombatRollClient.hudConfig.value).rollWidget;
        Vec2 originPoint = rollWidget.origin.getPoint(screenWidth, screenHeight);
        Vec2 drawOffset = rollWidget.offset;
        int horizontalSpacing = 8;
        int biggestTextureSize = 15;
        int widgetWidth = biggestTextureSize + horizontalSpacing * viewModel.elements.size();
        int widgetHeight = biggestTextureSize;
        int drawX = (int)(originPoint.f_82470_ + drawOffset.f_82470_);
        int drawY = (int)(originPoint.f_82471_ + drawOffset.f_82471_ - (float)(widgetHeight / 2));
        RenderSystem.m_69478_();
        for (ViewModel.Element element : viewModel.elements()) {
            int x = 0;
            int y = 0;
            boolean u = false;
            int v = 0;
            int width = 0;
            int height = 0;
            int textureSize = 0;
            x = drawX;
            y = drawY;
            u = false;
            v = 0;
            textureSize = 15;
            height = 15;
            width = 15;
            RenderSystem.m_157456_((int)0, (ResourceLocation)ARROW_BACKGROUND);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)config.hudBackgroundOpacity / 100.0f));
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)((float)u), (float)v, (int)width, (int)height, (int)textureSize, (int)textureSize);
            int color = element.color;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            int prevTextureSize = textureSize;
            textureSize = 13;
            int shift = (prevTextureSize - textureSize) / 2;
            width = textureSize;
            height = Math.round(element.full * (float)textureSize);
            x = drawX + shift;
            y = drawY + textureSize - height + shift;
            u = false;
            v = textureSize - height;
            RenderSystem.m_157456_((int)0, (ResourceLocation)ARROW);
            RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)element.full);
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)((float)u), (float)v, (int)width, (int)height, (int)textureSize, (int)textureSize);
            drawX += horizontalSpacing;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private record ViewModel(List<Element> elements) {
        static ViewModel create(RollManager.CooldownInfo info, float tickDelta) {
            ClientConfig config = CombatRollClient.config;
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < info.maxRolls(); ++i) {
                int color = config.hudArrowColor;
                float full = 0.0f;
                if (i == info.availableRolls()) {
                    int sparkleTicks;
                    int missingTicks;
                    full = (float)info.elapsed() / (float)info.total();
                    full = Math.min(full, 1.0f);
                    if (config.playCooldownFlash && (missingTicks = info.total() - info.elapsed()) <= (sparkleTicks = 2)) {
                        float sparkle = (float)(sparkleTicks / 2) - ((float)(missingTicks - 1) + (1.0f - tickDelta)) / (float)sparkleTicks;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        int redBits = (int)(ViewModel.mixNumberFloat(red, 1.0f, sparkle) * 255.0f);
                        int greenBits = (int)(ViewModel.mixNumberFloat(green, 1.0f, sparkle) * 255.0f);
                        int blueBits = (int)(ViewModel.mixNumberFloat(blue, 1.0f, sparkle) * 255.0f);
                        color = redBits;
                        color = (color << 8) + greenBits;
                        color = (color << 8) + blueBits;
                    }
                }
                if (i < info.availableRolls()) {
                    full = 1.0f;
                }
                elements.add(new Element(color, full));
            }
            return new ViewModel(elements);
        }

        static ViewModel mock() {
            ClientConfig config = CombatRollClient.config;
            int color = config.hudArrowColor;
            return new ViewModel(List.of(new Element(color, 1.0f), new Element(color, 0.5f), new Element(color, 0.0f)));
        }

        private static float mixNumberFloat(float a, float b, float bias) {
            return a + (b - a) * bias;
        }

        record Element(int color, float full) {
        }
    }
}

