/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.handler;

import com.mojang.math.Vector3f;
import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.handler.EntityAIHurt;
import io.github.flemmli97.mobbattle.handler.EntityAITeamTarget;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class Utils {
    public static Map<ChatFormatting, DustParticleOptions> teamColor = new HashMap<ChatFormatting, DustParticleOptions>();
    private static final Predicate<Goal> targetGoal;

    public static String getTeam(Entity entity) {
        return entity.m_5647_() != null ? entity.m_5647_().m_5758_() : "none";
    }

    public static boolean isOnSameTeam(Entity entity, Entity entity2) {
        if (entity.m_5647_() != null && entity2.m_5647_() != null) {
            return entity.m_7307_(entity2);
        }
        return false;
    }

    public static boolean canTargetEntity(Entity entity, Entity entity2) {
        if (entity.m_5647_() == null || entity2.m_5647_() == null) {
            return false;
        }
        return !entity.m_7307_(entity2);
    }

    public static void addEntityToTeam(Entity entity, String team) {
        Scoreboard score = entity.f_19853_.m_6188_();
        PlayerTeam scoreTeam = score.m_83489_(team);
        if (scoreTeam == null) {
            scoreTeam = score.m_83492_(team);
            scoreTeam.m_83344_(Team.CollisionRule.PUSH_OTHER_TEAMS);
        }
        score.m_83489_(team).m_6809_().size();
        score.m_6546_(entity.m_20149_(), scoreTeam);
    }

    public static int getTeamSize(Entity entity, String team) {
        return entity.f_19853_.m_6188_().m_83489_(team) != null ? entity.f_19853_.m_6188_().m_83489_(team).m_6809_().size() : 0;
    }

    public static void updateEntity(String team, Mob e) {
        Utils.addEntityToTeam((Entity)e, team);
        e.m_6710_(null);
        e.m_20049_("mobbattle:AddedAI");
        if (e.m_6095_().m_204039_(MobBattle.IGNORED)) {
            return;
        }
        Utils.removeGoal(CrossPlatformStuff.INSTANCE.goalSelectorFrom(e, true), targetGoal);
        CrossPlatformStuff.INSTANCE.goalSelectorFrom(e, true).m_25352_(0, (Goal)new EntityAIHurt(e));
        CrossPlatformStuff.INSTANCE.goalSelectorFrom(e, true).m_25352_(3, (Goal)new EntityAITeamTarget(e, false, true));
    }

    private static void removeGoal(GoalSelector goalSel, Predicate<Goal> pred) {
        Set<WrappedGoal> goals = goalSel.m_148105_().stream().filter(prio -> pred.test(prio.m_26015_())).collect(Collectors.toSet());
        goals.forEach(arg_0 -> ((GoalSelector)goalSel).m_25363_(arg_0));
    }

    public static AABB getBoundingBoxPositions(BlockPos pos, BlockPos pos2) {
        if (pos2 == null) {
            return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(pos);
        }
        int xDiff = pos.m_123341_() - pos2.m_123341_();
        int yDiff = pos.m_123342_() - pos2.m_123342_();
        int zDiff = pos.m_123343_() - pos2.m_123343_();
        int z2 = 0;
        int y2 = 0;
        int x2 = 0;
        int z = 0;
        int y = 0;
        int x = 0;
        if (xDiff <= 0) {
            x = 1;
        } else {
            x2 = 1;
        }
        if (yDiff <= 0) {
            y = 1;
        } else {
            y2 = 1;
        }
        if (zDiff <= 0) {
            z = 1;
        } else {
            z2 = 1;
        }
        return new AABB((double)x, (double)y, (double)z, (double)(xDiff + x2), (double)(yDiff + y2), (double)(zDiff + z2)).m_82338_(pos2);
    }

    public static Mob fromUUID(ServerLevel world, String uuid) {
        Entity e;
        if (uuid != null && (e = world.m_8791_(UUID.fromString(uuid))) instanceof Mob) {
            return (Mob)e;
        }
        return null;
    }

    public static void setAttackTarget(Mob entity, LivingEntity target, boolean both) {
        if (target == null) {
            return;
        }
        entity.m_6710_(target);
        entity.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_142081_(), 600L);
        entity.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)target, 600L);
        if (target instanceof Mob && both) {
            ((Mob)target).m_6710_((LivingEntity)entity);
            target.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)entity.m_142081_(), 600L);
            target.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)entity, 600L);
        }
    }

    static {
        teamColor.put(ChatFormatting.AQUA, new DustParticleOptions(new Vector3f(0.01f, 0.9f, 1.0f), 1.0f));
        teamColor.put(ChatFormatting.BLACK, new DustParticleOptions(new Vector3f(0.01f, 0.0f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.BLUE, new DustParticleOptions(new Vector3f(0.2f, 0.2f, 1.0f), 1.0f));
        teamColor.put(ChatFormatting.DARK_AQUA, new DustParticleOptions(new Vector3f(0.01f, 0.4f, 0.5f), 1.0f));
        teamColor.put(ChatFormatting.DARK_BLUE, new DustParticleOptions(new Vector3f(0.01f, 0.0f, 0.4f), 1.0f));
        teamColor.put(ChatFormatting.DARK_GRAY, new DustParticleOptions(new Vector3f(0.2f, 0.2f, 0.2f), 1.0f));
        teamColor.put(ChatFormatting.DARK_GREEN, new DustParticleOptions(new Vector3f(0.01f, 0.5f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.DARK_PURPLE, new DustParticleOptions(new Vector3f(0.3f, 0.0f, 0.4f), 1.0f));
        teamColor.put(ChatFormatting.DARK_RED, new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.GOLD, new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.GRAY, new DustParticleOptions(new Vector3f(0.4f, 0.4f, 0.4f), 1.0f));
        teamColor.put(ChatFormatting.GREEN, new DustParticleOptions(new Vector3f(0.01f, 1.0f, 0.0f), 1.0f));
        teamColor.put(ChatFormatting.LIGHT_PURPLE, new DustParticleOptions(new Vector3f(0.6f, 0.0f, 0.7f), 1.0f));
        teamColor.put(ChatFormatting.RED, new DustParticleOptions(new Vector3f(1.0f, 0.2f, 0.2f), 1.0f));
        teamColor.put(ChatFormatting.WHITE, new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f));
        teamColor.put(ChatFormatting.YELLOW, new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f));
        targetGoal = goal -> true;
    }
}

