/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.forge.network;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.forge.ModItems;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class EquipMessage {
    public ItemStack equipment;
    public int entityId;
    public int slot;

    public EquipMessage(ItemStack stack, int entityId, int slot) {
        this.equipment = stack;
        this.entityId = entityId;
        this.slot = slot;
    }

    public static EquipMessage fromBytes(FriendlyByteBuf buf) {
        CompoundTag compound = buf.m_130260_();
        return new EquipMessage(compound.m_128441_("Stack") ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("Stack")) : ItemStack.f_41583_, compound.m_128451_("EntityID"), compound.m_128451_("Slot"));
    }

    public static void toBytes(EquipMessage msg, FriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        compound.m_128405_("EntityID", msg.entityId);
        if (msg.equipment != null) {
            compound.m_128365_("Stack", (Tag)msg.equipment.m_41739_(tag));
        }
        compound.m_128405_("Slot", msg.slot);
        buf.m_130079_(compound);
    }

    public static void onMessage(EquipMessage msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getSender() == null || ctx.get().getSender().m_21205_().m_41720_() != ModItems.mobArmor.get()) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            Entity e = world.m_6815_(msg.entityId);
            if (e instanceof Mob) {
                e.m_8061_(MobBattle.slot[msg.slot], msg.equipment);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

