/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.forge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.mobbattle.client.gui.GuiArmor;
import io.github.flemmli97.mobbattle.client.gui.MultiItemColor;
import io.github.flemmli97.mobbattle.forge.ModItems;
import io.github.flemmli97.mobbattle.forge.ModMenuType;
import io.github.flemmli97.mobbattle.handler.Utils;
import io.github.flemmli97.mobbattle.items.MobArmy;
import io.github.flemmli97.mobbattle.items.MobEquip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEvents {
    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(ClientEvents::registerTextureSprite);
        modbus.addListener(ClientEvents::spawnEggColor);
        modbus.addListener(ClientEvents::clientSetup);
    }

    @SubscribeEvent
    public void render(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() == ModItems.mobArmy.get()) {
            MobArmy item = (MobArmy)heldItem.m_41720_();
            BlockPos pos = item.getSelPos(heldItem)[0];
            BlockPos pos2 = item.getSelPos(heldItem)[1];
            if (pos != null) {
                ClientEvents.renderBlockOutline(event.getPoseStack(), Minecraft.m_91087_().m_91269_().m_110108_(), pos, pos2);
            }
        } else if (heldItem.m_41720_() == ModItems.mobEquip.get()) {
            MobEquip item = (MobEquip)heldItem.m_41720_();
            BlockPos pos = item.getSelPos(heldItem)[0];
            BlockPos pos2 = item.getSelPos(heldItem)[1];
            if (pos != null) {
                ClientEvents.renderBlockOutline(event.getPoseStack(), Minecraft.m_91087_().m_91269_().m_110108_(), pos, pos2);
            }
        }
    }

    private static void renderBlockOutline(PoseStack stack, MultiBufferSource.BufferSource buffer, BlockPos pos, BlockPos pos2) {
        Vec3 vec = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        AABB aabb = Utils.getBoundingBoxPositions(pos, pos2).m_82406_(0.1);
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)aabb.m_82400_(0.002).m_82386_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_), (float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
        buffer.m_109912_((RenderType)RenderType.f_110371_);
    }

    public static void registerTextureSprite(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            event.addSprite(new ResourceLocation("mobbattle", "gui/armor_slot_sword"));
        }
    }

    public static void spawnEggColor(ColorHandlerEvent.Item e) {
        e.getItemColors().m_92689_((ItemColor)new MultiItemColor(), new ItemLike[]{(ItemLike)ModItems.spawner.get()});
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ModMenuType.armorMenu.get()), GuiArmor::new));
    }
}

