/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.MultiChunkFeatureGenerator;
import vazkii.quark.content.world.module.ChorusVegetationModule;

public class ChorusVegetationGenerator
extends MultiChunkFeatureGenerator {
    public ChorusVegetationGenerator() {
        super(DimensionConfig.end(false), () -> true, 2093L);
    }

    @Override
    public int getFeatureRadius() {
        return ChorusVegetationModule.radius;
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        Holder<Biome> b;
        if (!chunkCorner.m_123314_(Vec3i.f_123288_, 1050.0) && ChorusVegetationModule.rarity > 0 && random.nextInt(ChorusVegetationModule.rarity) == 0 && (b = this.getBiome((LevelAccessor)world, chunkCorner, true)).m_203373_(Biomes.f_48164_.m_135782_())) {
            return new BlockPos[]{chunkCorner};
        }
        return new BlockPos[0];
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random rand, BlockPos pos, WorldGenRegion worldIn) {
        for (int i = 0; i < ChorusVegetationModule.chunkAttempts; ++i) {
            BlockState stateAt;
            BlockPos placePos = pos.m_142082_(rand.nextInt(16), 100, rand.nextInt(16));
            Holder<Biome> b = this.getBiome((LevelAccessor)worldIn, placePos, true);
            double chance = this.getChance(b);
            double dist = (placePos.m_123341_() - src.m_123341_()) * (placePos.m_123341_() - src.m_123341_()) + (placePos.m_123343_() - src.m_123343_()) * (placePos.m_123343_() - src.m_123343_());
            int ditherStart = 6;
            if (dist > (double)(ditherStart *= ditherStart)) {
                chance *= 1.0 - Math.atan((dist - (double)ditherStart) / 50.0) / 1.5707963267948966;
            }
            if (!(chance > 0.0) || !(rand.nextDouble() < chance)) continue;
            while (placePos.m_123342_() > 40 && (stateAt = worldIn.m_8055_(placePos)).m_60734_() != Blocks.f_50259_) {
                placePos = placePos.m_7495_();
            }
            if (worldIn.m_8055_(placePos).m_60734_() != Blocks.f_50259_ || !worldIn.m_8055_(placePos.m_7494_()).m_60795_()) continue;
            Block block = rand.nextDouble() < 0.1 ? ChorusVegetationModule.chorus_twist : ChorusVegetationModule.chorus_weeds;
            worldIn.m_7731_(placePos.m_7494_(), block.m_49966_(), 2);
        }
    }

    private double getChance(Holder<Biome> b) {
        if (b.m_203373_(Biomes.f_48164_.m_135782_())) {
            return ChorusVegetationModule.highlandsChance;
        }
        if (b.m_203373_(Biomes.f_48163_.m_135782_())) {
            return ChorusVegetationModule.midlandsChance;
        }
        return ChorusVegetationModule.otherEndBiomesChance;
    }
}

