/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.handler.BrewingHandler;

public class PotionIngredient
extends Ingredient {
    private final Item item;
    private final Potion potion;

    public PotionIngredient(Item item, Potion potion) {
        super(Stream.of(new Ingredient.ItemValue(BrewingHandler.of(item, potion))));
        this.item = item;
        this.potion = potion;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.item == input.m_41720_() && PotionUtils.m_43579_((ItemStack)input) == this.potion;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.toString(CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE)));
        json.addProperty("item", Objects.toString(this.item.getRegistryName()));
        json.addProperty("potion", Objects.toString(this.potion.getRegistryName()));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PotionIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public PotionIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(buffer.m_130281_());
            return new PotionIngredient(item, potion);
        }

        @Nonnull
        public PotionIngredient parse(@Nonnull JsonObject json) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.getAsJsonPrimitive("item").getAsString()));
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(json.getAsJsonPrimitive("potion").getAsString()));
            return new PotionIngredient(item, potion);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull PotionIngredient ingredient) {
            buffer.m_130070_(Objects.toString(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)ingredient.item)));
            buffer.m_130070_(Objects.toString(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)ingredient.potion)));
        }
    }
}

