/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake.texture;

import customskinloader.fake.texture.FakeImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class FakeBufferedImage
implements FakeImage {
    private BufferedImage image;
    private Graphics graphics;

    public FakeBufferedImage(int width, int height) {
        this(new BufferedImage(width, height, 2));
    }

    public FakeBufferedImage(BufferedImage image) {
        this.image = image;
        this.graphics = image.getGraphics();
    }

    public BufferedImage getImage() {
        this.graphics.dispose();
        return this.image;
    }

    @Override
    public FakeImage createImage(int width, int height) {
        return new FakeBufferedImage(width, height);
    }

    @Override
    public FakeImage createImage(InputStream is) throws IOException {
        return new FakeBufferedImage(ImageIO.read(is));
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getRGBA(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public void setRGBA(int x, int y, int rgba) {
        this.image.setRGB(x, y, rgba);
    }

    @Override
    public void copyImageData(FakeImage image) {
        if (!(image instanceof FakeBufferedImage)) {
            return;
        }
        BufferedImage img = ((FakeBufferedImage)image).getImage();
        this.graphics.drawImage(img, 0, 0, null);
    }

    @Override
    public void fillArea(int x0, int y0, int width, int height) {
        this.graphics.setColor(new Color(0, 0, 0, 0));
        this.graphics.fillRect(x0, y0, width, height);
    }

    @Override
    public void copyArea(int x0, int y0, int dx, int dy, int width, int height, boolean reversex, boolean reversey) {
        int x1 = x0 + width;
        int x2 = x0 + dx;
        int x3 = x2 + width;
        int y1 = y0 + height;
        int y2 = y0 + dy;
        int y3 = y2 + height;
        this.graphics.drawImage(this.image, reversex ? x3 : x2, reversey ? y3 : y2, reversex ? x2 : x3, reversey ? y2 : y3, x0, y0, x1, y1, null);
    }

    @Override
    public void close() {
        this.graphics.dispose();
    }
}

