/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.platform.NativeImage;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeMinecraftProfileTexture;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.IFakeImageBuffer;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.MinecraftUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;

public class FakeSkinManager {
    private final TextureManager textureManager;
    private final Map<ResourceLocation, MinecraftProfileTexture> modelCache = new ConcurrentHashMap<ResourceLocation, MinecraftProfileTexture>();
    private static final String KEY = "CustomSkinLoaderInfo";

    public FakeSkinManager(TextureManager textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService) {
        this.textureManager = textureManagerInstance;
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public static ResourceLocation setResourceLocation(ResourceLocation resourceLocation, MinecraftProfileTexture profileTexture) {
        if (profileTexture instanceof FakeMinecraftProfileTexture) {
            ((FakeMinecraftProfileTexture)profileTexture).setResourceLocation(resourceLocation);
        }
        return resourceLocation;
    }

    public static MinecraftProfileTexture getModelCache(MinecraftProfileTexture profileTexture, FakeSkinManager fakeManager, ResourceLocation location) {
        return fakeManager.modelCache.getOrDefault(location, profileTexture);
    }

    public static Object[] createThreadDownloadImageData(ImmutableList<Object> list, FakeSkinManager fakeManager, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, SkinManager.SkinTextureCallback skinAvailableCallback) {
        Object[] params = list.toArray();
        if (profileTexture instanceof FakeMinecraftProfileTexture && params.length > 1) {
            FakeMinecraftProfileTexture fakeProfileTexture = (FakeMinecraftProfileTexture)profileTexture;
            ResourceLocation resourcelocation = fakeProfileTexture.getResourceLocation();
            if (fakeProfileTexture.getResourceLocation() != null) {
                params[0] = fakeProfileTexture.getCacheFile();
                if (params[params.length - 2] instanceof Boolean) {
                    params[params.length - 2] = true;
                }
                int n = params.length - 1;
                FakeSkinManager fakeSkinManager = fakeManager;
                fakeSkinManager.getClass();
                params[n] = fakeSkinManager.new BaseBuffer(skinAvailableCallback, textureType, resourcelocation, fakeProfileTexture);
            }
        }
        return params;
    }

    public static void loadProfileTextures(Runnable runnable, GameProfile profile) {
        CustomSkinLoader.loadProfileTextures(() -> CustomSkinLoader.loadProfileLazily(profile, m -> {
            profile.getProperties().put((Object)KEY, m);
            runnable.run();
        }));
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getUserProfile(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        return profile.getProperties().removeAll((Object)KEY).stream().findFirst().orElse(Maps.newHashMap());
    }

    public static void loadElytraTexture(SkinManager skinManager, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map, SkinManager.SkinTextureCallback skinAvailableCallback) {
        for (int i = 2; i < MinecraftProfileTexture.Type.values().length; ++i) {
            MinecraftProfileTexture.Type type = MinecraftProfileTexture.Type.values()[i];
            if (!map.containsKey(type)) continue;
            skinManager.loadSkin(map.get(type), type, skinAvailableCallback);
        }
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = CustomSkinLoader.loadProfileFromCache(profile);
        Iterator<Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture> entry = it.next();
            MinecraftProfileTexture texture = entry.getValue();
            if (!FakeSkinManager.shouldJudgeType(texture)) continue;
            texture = this.modelCache.get(MinecraftUtil.getSkinManager().m_118825_(texture, entry.getKey()));
            if (texture == null) {
                it.remove();
                continue;
            }
            map.put(entry.getKey(), texture);
        }
        return map;
    }

    private static void makeCallback(SkinManager.SkinTextureCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
        if (callback != null) {
            callback.m_118856_(type, location, texture);
        }
    }

    private static boolean shouldJudgeType(MinecraftProfileTexture texture) {
        return texture != null && "auto".equals(texture.getMetadata("model"));
    }

    private class BaseBuffer
    implements IFakeImageBuffer {
        private IFakeImageBuffer buffer;
        private SkinManager.SkinTextureCallback callback;
        private MinecraftProfileTexture.Type type;
        private ResourceLocation location;
        private FakeMinecraftProfileTexture texture;

        public BaseBuffer(SkinManager.SkinTextureCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, FakeMinecraftProfileTexture texture) {
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer(location);
                }
            }
            this.callback = callback;
            this.type = type;
            this.location = location;
            this.texture = texture;
        }

        @Override
        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_195786_a(image) : image;
        }

        @Override
        public BufferedImage parseUserSkin(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).parseUserSkin(image) : image;
        }

        @Override
        public void skinAvailable() {
            if (this.buffer != null) {
                this.buffer.skinAvailable();
                if (FakeSkinManager.shouldJudgeType(this.texture) && this.buffer instanceof FakeSkinBuffer) {
                    HashMap metadata = Maps.newHashMap();
                    String type = ((FakeSkinBuffer)this.buffer).judgeType();
                    metadata.put("model", type);
                    this.texture = new FakeMinecraftProfileTexture(this.texture.getRawUrl(), metadata);
                    FakeSkinManager.this.modelCache.put(this.location, this.texture);
                }
            }
            FakeSkinManager.makeCallback(this.callback, this.type, this.location, this.texture);
        }
    }
}

