/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.ghost;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.gui.ghost.GhostIngredientDrag;
import mezz.jei.common.gui.ghost.GhostIngredientReturning;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GhostIngredientDragManager {
    private final IRecipeFocusSource source;
    private final GuiScreenHelper guiScreenHelper;
    private final RegisteredIngredients registeredIngredients;
    private final IWorldConfig worldConfig;
    private final List<GhostIngredientReturning<?>> ghostIngredientsReturning = new ArrayList();
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private ITypedIngredient<?> hoveredIngredient;
    @Nullable
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets;

    public GhostIngredientDragManager(IRecipeFocusSource source, GuiScreenHelper guiScreenHelper, RegisteredIngredients registeredIngredients, IWorldConfig worldConfig) {
        this.source = source;
        this.guiScreenHelper = guiScreenHelper;
        this.registeredIngredients = registeredIngredients;
        this.worldConfig = worldConfig;
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (!(minecraft.f_91080_ instanceof AbstractContainerScreen)) {
            this.drawGhostIngredientHighlights(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(minecraft, poseStack, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(minecraft, poseStack));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        this.drawGhostIngredientHighlights(minecraft, poseStack, mouseX, mouseY);
    }

    private void drawGhostIngredientHighlights(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(poseStack, mouseX, mouseY);
        } else {
            ITypedIngredient hovered = this.source.getIngredientUnderMouse(mouseX, mouseY).map(IClickedIngredient::getTypedIngredient).findFirst().orElse(null);
            if (!GhostIngredientDragManager.equals(hovered, this.hoveredIngredient)) {
                IGhostIngredientHandler<Screen> handler;
                this.hoveredIngredient = hovered;
                this.hoveredIngredientTargets = null;
                Screen currentScreen = minecraft.f_91080_;
                if (currentScreen != null && hovered != null && (handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen)) != null && handler.shouldHighlightTargets()) {
                    this.hoveredIngredientTargets = handler.getTargets(currentScreen, hovered, false);
                }
            }
            if (this.hoveredIngredientTargets != null && !this.worldConfig.isCheatItemsEnabled()) {
                GhostIngredientDrag.drawTargets(poseStack, mouseX, mouseY, this.hoveredIngredientTargets);
            }
        }
    }

    private static boolean equals(@Nullable ITypedIngredient<?> a, @Nullable ITypedIngredient<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getIngredient() == b.getIngredient();
    }

    public void stopDrag() {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.stop();
            this.ghostIngredientDrag = null;
        }
        this.hoveredIngredient = null;
        this.hoveredIngredientTargets = null;
    }

    private <T extends Screen, V> boolean handleClickGhostIngredient(T currentScreen, IClickedIngredient<V> clicked, UserInput input) {
        IGhostIngredientHandler<T> handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen);
        if (handler == null) {
            return false;
        }
        ITypedIngredient<V> value = clicked.getTypedIngredient();
        V ingredient = value.getIngredient();
        IIngredientType<V> type = value.getType();
        List targets = handler.getTargets(currentScreen, ingredient, true);
        if (targets.isEmpty()) {
            return false;
        }
        IIngredientRenderer<V> ingredientRenderer = this.registeredIngredients.getIngredientRenderer(type);
        ImmutableRect2i clickedArea = clicked.getArea();
        this.ghostIngredientDrag = new GhostIngredientDrag(handler, targets, ingredientRenderer, ingredient, input.getMouseX(), input.getMouseY(), clickedArea);
        return true;
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        public Optional<IUserInputHandler> handleDragStart(Screen screen, UserInput input) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return Optional.empty();
            }
            return GhostIngredientDragManager.this.source.getIngredientUnderMouse(input.getMouseX(), input.getMouseY()).findFirst().flatMap(clicked -> {
                ItemStack mouseItem = player.f_36096_.m_142621_();
                if (mouseItem.m_41619_() && GhostIngredientDragManager.this.handleClickGhostIngredient(screen, clicked, input)) {
                    return Optional.of(this);
                }
                return Optional.empty();
            });
        }

        @Override
        public Optional<IUserInputHandler> handleDragComplete(Screen screen, UserInput input) {
            if (GhostIngredientDragManager.this.ghostIngredientDrag == null) {
                return Optional.empty();
            }
            boolean success = GhostIngredientDragManager.this.ghostIngredientDrag.onClick(input);
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            if (!success && GhostIngredientDrag.farEnoughToDraw(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY)) {
                GhostIngredientReturning<?> returning = GhostIngredientReturning.create(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY);
                GhostIngredientDragManager.this.ghostIngredientsReturning.add(returning);
            }
            GhostIngredientDragManager.this.ghostIngredientDrag = null;
            GhostIngredientDragManager.this.hoveredIngredientTargets = null;
            if (success) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public void handleDragCanceled() {
            GhostIngredientDragManager.this.stopDrag();
        }
    }
}

