/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.common.config.file.ConfigCategoryBuilder;
import mezz.jei.common.config.file.ConfigSchema;

public class ConfigSchemaBuilder {
    private final Set<String> categoryNames = new HashSet<String>();
    private final List<ConfigCategoryBuilder> categoryBuilders = new ArrayList<ConfigCategoryBuilder>();

    public ConfigCategoryBuilder addCategory(String name) {
        if (!this.categoryNames.add(name)) {
            throw new IllegalArgumentException("There is already a category named: " + name);
        }
        ConfigCategoryBuilder category = new ConfigCategoryBuilder(name);
        this.categoryBuilders.add(category);
        return category;
    }

    public ConfigSchema build(Path path) {
        return new ConfigSchema(path, this.categoryBuilders);
    }
}

