/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.common.config.file.ConfigCategory;
import mezz.jei.common.config.file.ConfigSchema;
import mezz.jei.common.config.file.ConfigValue;
import mezz.jei.common.config.file.serializers.BooleanSerializer;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.common.config.file.serializers.IConfigValueSerializer;
import mezz.jei.common.config.file.serializers.IntegerSerializer;
import mezz.jei.common.config.file.serializers.ListSerializer;

public class ConfigCategoryBuilder {
    private final String name;
    private final List<ConfigValue<?>> values = new ArrayList();

    public ConfigCategoryBuilder(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public <T> Supplier<T> addValue(ConfigValue<T> value) {
        this.values.add(value);
        return value::getValue;
    }

    public Supplier<Boolean> addBoolean(String name, boolean defaultValue, String description) {
        return this.addValue(new ConfigValue<Boolean>(name, defaultValue, BooleanSerializer.INSTANCE, description));
    }

    public <T extends Enum<T>> Supplier<T> addEnum(String name, T defaultValue, String description) {
        EnumSerializer<T> serializer = new EnumSerializer<T>(defaultValue.getDeclaringClass());
        return this.addValue(new ConfigValue<T>(name, defaultValue, serializer, description));
    }

    public Supplier<Integer> addInteger(String name, int defaultValue, int minValue, int maxValue, String description) {
        IntegerSerializer serializer = new IntegerSerializer(minValue, maxValue);
        return this.addValue(new ConfigValue<Integer>(name, defaultValue, serializer, description));
    }

    public <T> Supplier<List<T>> addList(String name, List<T> defaultValue, IConfigValueSerializer<T> valueSerializer, String description) {
        ListSerializer<T> serializer = new ListSerializer<T>(valueSerializer);
        return this.addValue(new ConfigValue<List<T>>(name, defaultValue, serializer, description));
    }

    public ConfigCategory build(ConfigSchema schema) {
        for (ConfigValue<?> value : this.values) {
            value.setSchema(schema);
        }
        return new ConfigCategory(this.name, this.values);
    }
}

