/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.utilities;

import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WorldUtil {
    @Nullable
    public static Vec3 getWall(LivingEntity entity) {
        double d = 0.3;
        double distance = entity.m_20205_() / 2.0f;
        double wallX = 0.0;
        double wallZ = 0.0;
        int wallNumX = 0;
        int wallNumZ = 0;
        Vec3 pos = entity.m_20182_();
        AABB baseBox = new AABB(pos.m_7096_() - 0.3, pos.m_7098_(), pos.m_7094_() - 0.3, pos.m_7096_() + 0.3, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + 0.3);
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(distance, 0.0, 0.0))) {
            wallX += 1.0;
            wallNumX = (byte)(wallNumX + 1);
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(-distance, 0.0, 0.0))) {
            wallX -= 1.0;
            wallNumX = (byte)(wallNumX + 1);
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(0.0, 0.0, distance))) {
            wallZ += 1.0;
            wallNumZ = (byte)(wallNumZ + 1);
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(0.0, 0.0, -distance))) {
            wallZ -= 1.0;
            wallNumZ = (byte)(wallNumZ + 1);
        }
        if (wallNumX == 2 || wallNumZ == 2 || wallNumX == 0 && wallNumZ == 0) {
            return null;
        }
        return new Vec3(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vec3 getVaultableStep(LivingEntity entity) {
        double d = 0.3;
        Level world = entity.f_19853_;
        double distance = entity.m_20205_() / 2.0f;
        double baseLine = 1.55;
        double stepX = 0.0;
        double stepZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBoxSide = new AABB(pos.m_7096_() - 0.3, pos.m_7098_(), pos.m_7094_() - 0.3, pos.m_7096_() + 0.3, pos.m_7098_() + baseLine, pos.m_7094_() + 0.3);
        AABB baseBoxTop = new AABB(pos.m_7096_() - 0.3, pos.m_7098_() + baseLine, pos.m_7094_() - 0.3, pos.m_7096_() + 0.3, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + 0.3);
        if (!world.m_45772_(baseBoxSide.m_82363_(distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(distance + 1.8, 0.0, 0.0))) {
            stepX += 1.0;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(-distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(-(distance + 1.8), 0.0, 0.0))) {
            stepX -= 1.0;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(0.0, 0.0, distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, distance + 1.8))) {
            stepZ += 1.0;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(0.0, 0.0, -distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, -(distance + 1.8)))) {
            stepZ -= 1.0;
        }
        if (stepX == 0.0 && stepZ == 0.0) {
            return null;
        }
        return new Vec3(stepX, 0.0, stepZ);
    }

    public static double getWallHeight(LivingEntity entity) {
        Vec3 wall = WorldUtil.getWall(entity);
        if (wall == null) {
            return 0.0;
        }
        Level world = entity.f_19853_;
        double v = 0.1;
        double d = 0.3;
        int loopNum = (int)Math.round((double)entity.m_20206_() / 0.1);
        Vec3 pos = entity.m_20182_();
        double x1 = pos.m_7096_() + 0.3 + (double)(wall.m_7096_() > 0.0 ? 1 : 0);
        double y1 = pos.m_7098_();
        double z1 = pos.m_7094_() + 0.3 + (double)(wall.m_7094_() > 0.0 ? 1 : 0);
        double x2 = pos.m_7096_() - 0.3 + (double)(wall.m_7096_() < 0.0 ? -1 : 0);
        double z2 = pos.m_7094_() - 0.3 + (double)(wall.m_7094_() < 0.0 ? -1 : 0);
        boolean canReturn = false;
        for (int i = 0; i < loopNum; ++i) {
            AABB box = new AABB(x1, y1 + 0.1 * (double)i, z1, x2, y1 + 0.1 * (double)(i + 1), z2);
            if (!world.m_45772_(box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return 0.1 * (double)i;
        }
        return entity.m_20206_();
    }

    public static boolean existsGrabbableWall(LivingEntity entity) {
        double d = 0.3;
        Level world = entity.f_19853_;
        double distance = entity.m_20205_() / 2.0f;
        double baseLine1 = entity.m_20192_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        double baseLine2 = entity.m_20206_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        return WorldUtil.existsGrabbableWall(entity, distance, baseLine1) || WorldUtil.existsGrabbableWall(entity, distance, baseLine2);
    }

    private static boolean existsGrabbableWall(LivingEntity entity, double distance, double baseLine) {
        double d = 0.3;
        Level world = entity.f_19853_;
        Vec3 pos = entity.m_20182_();
        AABB baseBoxSide = new AABB(pos.m_7096_() - 0.3, pos.m_7098_() + baseLine - (double)(entity.m_20206_() / 6.0f), pos.m_7094_() - 0.3, pos.m_7096_() + 0.3, pos.m_7098_() + baseLine, pos.m_7094_() + 0.3);
        AABB baseBoxTop = new AABB(pos.m_7096_() - 0.3, pos.m_7098_() + baseLine, pos.m_7094_() - 0.3, pos.m_7096_() + 0.3, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + 0.3);
        if (!world.m_45772_(baseBoxSide.m_82363_(distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(distance, 0.0, 0.0))) {
            return true;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(-distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(-distance, 0.0, 0.0))) {
            return true;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(0.0, 0.0, distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, distance))) {
            return true;
        }
        return !world.m_45772_(baseBoxSide.m_82363_(0.0, 0.0, -distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, -distance));
    }
}

