/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.constants.ActionsEnum;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SetActionPossibilityMessage {
    private ActionsEnum actionsEnum = null;
    private boolean possibility = false;

    public void encode(FriendlyByteBuf packet) {
        packet.writeBoolean(this.possibility);
        packet.writeInt(this.actionsEnum.name().length());
        packet.writeCharSequence((CharSequence)this.actionsEnum.name(), StandardCharsets.UTF_8);
    }

    public static SetActionPossibilityMessage decode(FriendlyByteBuf packet) {
        SetActionPossibilityMessage message = new SetActionPossibilityMessage();
        message.possibility = packet.readBoolean();
        message.actionsEnum = ActionsEnum.valueOf(packet.readCharSequence(packet.readInt(), StandardCharsets.UTF_8).toString());
        return message;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getNetworkManager().getDirection() == PacketFlow.CLIENTBOUND) {
                ParCoolConfig.Client c = ParCoolConfig.CONFIG_CLIENT;
                switch (this.actionsEnum) {
                    case Crawl: {
                        c.canCrawl.set((Object)this.possibility);
                        break;
                    }
                    case CatLeap: {
                        c.canCatLeap.set((Object)this.possibility);
                        break;
                    }
                    case Dodge: {
                        c.canDodge.set((Object)this.possibility);
                        break;
                    }
                    case FastRunning: {
                        c.canFastRunning.set((Object)this.possibility);
                        break;
                    }
                    case Roll: {
                        c.canRoll.set((Object)this.possibility);
                        break;
                    }
                    case Vault: {
                        c.canVault.set((Object)this.possibility);
                        break;
                    }
                    case WallJump: {
                        c.canWallJump.set((Object)this.possibility);
                        break;
                    }
                    case GrabCliff: {
                        c.canClingToCliff.set((Object)this.possibility);
                        break;
                    }
                    case InfiniteStamina: {
                        c.infiniteStamina.set((Object)this.possibility);
                    }
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public static void send(ServerPlayer player, ActionsEnum actionsEnum, boolean possibility) {
        SetActionPossibilityMessage message = new SetActionPossibilityMessage();
        message.actionsEnum = actionsEnum;
        message.possibility = possibility;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }
}

