/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ResetFallDistanceMessage {
    private UUID playerID = null;

    public void encode(FriendlyByteBuf packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static ResetFallDistanceMessage decode(FriendlyByteBuf packet) {
        ResetFallDistanceMessage message = new ResetFallDistanceMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getNetworkManager().getDirection() != PacketFlow.CLIENTBOUND) {
                ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                if (player == null) {
                    return;
                }
            } else {
                return;
            }
            player.f_19789_ = 0.0f;
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public static void sync(Player player) {
        player.f_19789_ = 0.0f;
        ResetFallDistanceMessage message = new ResetFallDistanceMessage();
        message.playerID = player.m_142081_();
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }
}

