/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.utilities.BufferUtil;
import java.nio.ByteBuffer;

public class ActionInfo {
    private boolean received = false;
    private boolean allowedInfiniteStamina = false;
    private int staminaMax;
    private int staminaConsumptionBreakfall = 0;
    private int staminaConsumptionCatLeap = 0;
    private int staminaConsumptionClingToCliff = 0;
    private int staminaConsumptionClimbUp = 0;
    private int staminaConsumptionDodge = 0;
    private int staminaConsumptionFastRun = 0;
    private int staminaConsumptionFlipping = 0;
    private int staminaConsumptionVault = 0;
    private int staminaConsumptionWallJump = 0;

    public int getStaminaConsumptionBreakfall() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionBreakfall.get(), this.staminaConsumptionBreakfall);
    }

    public int getStaminaConsumptionFlipping() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionFlipping.get(), this.staminaConsumptionFlipping);
    }

    public int getStaminaConsumptionVault() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionVault.get(), this.staminaConsumptionVault);
    }

    public int getStaminaConsumptionCatLeap() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionCatLeap.get(), this.staminaConsumptionCatLeap);
    }

    public int getStaminaConsumptionClingToCliff() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionClingToCliff.get(), this.staminaConsumptionClingToCliff);
    }

    public int getStaminaConsumptionClimbUp() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionClimbUp.get(), this.staminaConsumptionClimbUp);
    }

    public int getStaminaConsumptionDodge() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionDodge.get(), this.staminaConsumptionDodge);
    }

    public int getStaminaConsumptionFastRun() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionFastRun.get(), this.staminaConsumptionFastRun);
    }

    public int getStaminaConsumptionWallJump() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaConsumptionWallJump.get(), this.staminaConsumptionWallJump);
    }

    public int getMaxStamina() {
        return Math.max((Integer)ParCoolConfig.CONFIG_CLIENT.staminaMax.get(), this.staminaMax);
    }

    public double getCatLeapPower() {
        return 0.49;
    }

    public int getDodgeCoolTick() {
        return 10;
    }

    public int getMaxSlidingTick() {
        return 15;
    }

    public boolean isStaminaInfinite() {
        return (Boolean)ParCoolConfig.CONFIG_CLIENT.infiniteStamina.get() != false && this.allowedInfiniteStamina;
    }

    public static void encode(ByteBuffer buffer) {
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionBreakfall.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionCatLeap.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionClimbUp.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionDodge.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionClingToCliff.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionFastRun.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionFlipping.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionVault.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaConsumptionWallJump.get());
        buffer.putInt((Integer)ParCoolConfig.CONFIG_SERVER.staminaMax.get());
        BufferUtil.wrap(buffer).putBoolean((Boolean)ParCoolConfig.CONFIG_SERVER.allowInfiniteStamina.get());
    }

    public void decode(ByteBuffer buffer) {
        this.staminaConsumptionBreakfall = buffer.getInt();
        this.staminaConsumptionCatLeap = buffer.getInt();
        this.staminaConsumptionClimbUp = buffer.getInt();
        this.staminaConsumptionDodge = buffer.getInt();
        this.staminaConsumptionClingToCliff = buffer.getInt();
        this.staminaConsumptionFastRun = buffer.getInt();
        this.staminaConsumptionFlipping = buffer.getInt();
        this.staminaConsumptionVault = buffer.getInt();
        this.staminaConsumptionWallJump = buffer.getInt();
        this.staminaMax = buffer.getInt();
        this.allowedInfiniteStamina = BufferUtil.getBoolean(buffer);
    }

    public void receiveServerPermissions(ByteBuffer buffer) {
        this.received = true;
        this.decode(buffer);
    }
}

